/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/01/25 15:00:50
 */
package org.asyrinx.joey.gen.command.java;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import org.asyrinx.brownie.core.lang.StringUtils;
import org.asyrinx.joey.gen.model.Element;
import org.asyrinx.joey.gen.model.java.Entity;
import org.asyrinx.joey.gen.model.java.Property;
import org.asyrinx.joey.gen.model.java.Reference;

/**
 * @author takeshi
 */
public class CheckNameOfProperty extends JavaCommand {

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.command.java.JavaCommand#visit(org.asyrinx.joey.gen.model.java.Entity)
     */
    public void visit(Entity entity) {
        final Map checkedNames = new HashMap();
        for (Iterator i = entity.getPropertiesAll().iterator(); i.hasNext();) {
            final Element property = (Element) i.next();
            final String propertyName = property.getName();
            checkName(checkedNames, property, propertyName);
        }
        for (Iterator i = entity.getReferencesAll().iterator(); i.hasNext();) {
            final Reference reference = (Reference) i.next();
            final String propertyName = reference.getPropertyNameInLocal();
            checkName(checkedNames, reference, propertyName);
        }
        for (Iterator i = entity.getReferredAll().iterator(); i.hasNext();) {
            final Reference reference = (Reference) i.next();
            final String propertyName = reference.getPropertyNameInReferred();
            checkName(checkedNames, reference, propertyName);
        }
    }

    /**
     * @param checkedNames
     * @param element
     * @param propertyName
     */
    private void checkName(Map checkedNames, Element element, String propertyName) {
        if (StringUtils.isEmpty(propertyName)) {
            addError(element.getFullName() + "(" + element.getOriginal() + ")"
                    + " has no property name");
        }
        final Element duplicated = (Element) checkedNames.get(propertyName);
        if (duplicated != null) {
            if (isDuplicated(element, duplicated))
                addError("propertyName=" + propertyName + "  " + element + "("
                        + element.getOriginal() + ")" + " has duplicated property name with "
                        + duplicated + "(" + duplicated.getOriginal() + ")");
        }
        checkedNames.put(propertyName, element);
    }

    private boolean isDuplicated(Element element1, Element element2) {
        if (element1 == element2)
            return false;
        if ((element1 instanceof Property) && (element2 instanceof Property)) {
            if (isExtended((Property) element1, (Property) element2))
                return false;
            if (isExtended((Property) element2, (Property) element1))
                return false;
        }
        return true;
    }

    /**
     * @param property1
     * @param property2
     * @return
     */
    private boolean isExtended(Property property1, Property property2) {
        if (!property1.isExtended())
            return false;
        if (property1.getParent().getSuperClass() == property2.getParent())
            return true;
        return false;
    }

}