/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/08/15 18:00:19
 */
package org.asyrinx.joey.gen.command.rdb;

import org.apache.commons.lang.StringUtils;
import org.asyrinx.joey.gen.model.rdb.Column;
import org.asyrinx.joey.gen.model.rdb.ColumnType;

/**
 * @author akima
 */
public class CheckColumnType extends RdbCommand {

    public void visit(Column column) {
        if (StringUtils.isEmpty(column.getType()))
            addError(column, "column requires type");
        final ColumnType type = ColumnType.get(column.getType());
        if (type == null)
            addError(column, "type '" + column.getType() + "' not found");
        if (type.isRequiredSize() && column.getSizeAsInt() < 1)
            addError(column, "type '" + type.getName() + "' requires size");
    }

}