/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/08/15 18:00:19
 */
package org.asyrinx.joey.gen.command.rdb;

import org.asyrinx.joey.gen.model.rdb.Column;
import org.asyrinx.joey.gen.model.rdb.ColumnType;
import org.asyrinx.joey.gen.model.rdb.ForeignKeyEntry;

/**
 * @author akima
 */
public class CheckFkColumnType extends RdbCommand {

    public void visit(ForeignKeyEntry entry) {
        final Column localColumn = entry.getLocalColumn();
        if (localColumn == null)
            addError(entry, "local column not found. " + entry.getLocal());

        final Column foreignColumn = entry.getForeignColumn();
        if (foreignColumn == null)
            addError(entry, "foreign column not found. " + entry.getForeign());
        //
        if (!localColumn.getType().equals(foreignColumn.getType()))
            addError(entry, "column type different between " + localColumn.getType() + "(" + localColumn.getFullName()
                    + ") and " + foreignColumn.getType() + "(" + foreignColumn.getFullName() + ")");
        final ColumnType type = ColumnType.get(localColumn.getType());
        if (type == null)
            addError(localColumn, "type not found. " + localColumn.getType());
        if (type.isRequiredSize()) {
            if (localColumn.getSize() != foreignColumn.getSize())
                addError(entry, "column size different between " + localColumn.getSize() + "("
                        + localColumn.getFullName() + ") and " + foreignColumn.getSize() + "("
                        + foreignColumn.getFullName() + ")");
        }
    }

}