/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/08/15 18:00:19
 */
package org.asyrinx.joey.gen.command.rdb;

import org.apache.commons.lang.StringUtils;
import org.asyrinx.brownie.core.lang.ArrayUtils;
import org.asyrinx.joey.gen.hibernate.Cascade;
import org.asyrinx.joey.gen.model.rdb.ForeignKey;
import org.asyrinx.joey.gen.model.rdb.ForeignKeyEntry;
import org.asyrinx.joey.gen.model.rdb.Table;

/**
 * @author akima
 */
public class CheckForeignKey extends RdbCommand {

    public void visit(ForeignKey foreignKey) {
        if (StringUtils.isEmpty(foreignKey.getForeign()))
            addError(foreignKey, "foreignKey requires foreignTable");
        final Table foreignTable = foreignKey.getForeignTable();
        if (foreignTable == null)
            addError(foreignKey, "table '" + foreignKey.getForeign() + "' not found");
        if (!isAvailableCascadeValue(foreignKey.getCascade()))
            addError(foreignKey, "illegal cascade value '" + foreignKey.getCascade() + "'."
                    + "cascade must be " + ArrayUtils.toString(Cascade.CASCADES));
    }

    private boolean isAvailableCascadeValue(String cascade) {
        if (StringUtils.isEmpty(cascade))
            return true;
        for (int i = 0; i < Cascade.CASCADES.length; i++)
            if (Cascade.CASCADES[i].getName().equals(cascade))
                return true;
        return false;
    }

    public void visit(ForeignKeyEntry entry) {
        if (StringUtils.isEmpty(entry.getLocal()))
            addError(entry, "foreignKeyEntry requires local");
        if (StringUtils.isEmpty(entry.getForeign()))
            addError(entry, "foreignKeyEntry requires foreign");
        final ForeignKey foreignKey = entry.getParent();
        if (entry.getLocalColumn() == null)
            addError(entry, "column '" + entry.getLocal() + "' not found in table '"
                    + foreignKey.getLocal().getFullName() + "'");
        if (entry.getForeignColumn() == null)
            addError(entry, "column '" + entry.getForeign() + "' not found in table '"
                    + foreignKey.getForeignTable().getFullName() + "'");
    }

}