/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/11/09 16:32:12
 */
package org.asyrinx.joey.gen.command.rdb;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import org.asyrinx.joey.gen.model.Element;
import org.asyrinx.joey.gen.model.rdb.Database;
import org.asyrinx.joey.gen.model.rdb.RdbEnumeration;
import org.asyrinx.joey.gen.model.rdb.Table;

/**
 * @author takeshi
 */
public abstract class CheckNameDuplication extends RdbCommand {

    abstract protected Iterator getTargets(Element targetParent);

    public void checkDuplication(Element targetParent) {
        final Set elementNames = new HashSet();
        for (Iterator i = getTargets(targetParent); i.hasNext();) {
            final Element element = (Element) i.next();
            if (elementNames.contains(element.getName()))
                addError(element, element.getName() + " is duplicated.");
            elementNames.add(element.getName());
        }
    }

    public static class Tables extends CheckNameDuplication {
        public void visit(Database database) {
            super.checkDuplication(database);
        }

        protected Iterator getTargets(Element targetParent) {
            return ((Database) targetParent).getTables().iterator();
        }
    }

    public static class Columns extends CheckNameDuplication {
        public void visit(Table table) {
            super.checkDuplication(table);
        }

        protected Iterator getTargets(Element targetParent) {
            return ((Table) targetParent).getColumns().iterator();
        }
    }

    public static class Enumerations extends CheckNameDuplication {
        public void visit(Database database) {
            super.checkDuplication(database);
        }

        protected Iterator getTargets(Element targetParent) {
            return ((Database) targetParent).getEnumerations().iterator();
        }
    }

    public static class EnumerationEntries extends CheckNameDuplication {
        public void visit(RdbEnumeration enumeration) {
            super.checkDuplication(enumeration);
        }

        protected Iterator getTargets(Element targetParent) {
            return ((RdbEnumeration) targetParent).iterator();
        }
    }
}