/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/08/15 18:00:19
 */
package org.asyrinx.joey.gen.command.rdb;

import java.util.Iterator;

import org.asyrinx.joey.gen.model.rdb.Column;
import org.asyrinx.joey.gen.model.rdb.Table;

/**
 * @author akima
 */
public class CheckPrimaryKey extends RdbCommand {

    public void visit(Table table) {
        for (Iterator i = table.getColumns().iterator(); i.hasNext();) {
            final Column column = (Column) i.next();
            if (column.isPrimaryKey())
                return;
        }
        addError(table, "table has no primary key!");
    }

}