/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/11/10 9:43:18
 */
package org.asyrinx.joey.gen.command.rdb;

import java.util.Map;

import org.apache.commons.lang.StringUtils;
import org.asyrinx.joey.gen.model.Element;
import org.asyrinx.joey.gen.model.rdb.RdbEnumeration;
import org.asyrinx.joey.gen.model.rdb.Table;

/**
 * @author takeshi
 */
public class CopyAncestorOption extends RdbCommand {

    /**
     *  
     */
    public CopyAncestorOption(Object optionKey) {
        super();
        this.optionKey = optionKey;
    }

    protected final Object optionKey;

    public void visit(Table table) {
        table.getOptions().put(optionKey, getOptionValue(table));
    }

    public void visit(RdbEnumeration enumeration) {
        enumeration.getOptions().put(optionKey, getOptionValue(enumeration));
    }

    public String getOptionValue(Element element) {
        final String result = getAncestorOptionValue(element);
        if (result != null)
            return result;
        else
            return (element.getParentElement() == null) ? null : element.getParentElement().getName();
    }

    protected String getAncestorOptionValue(Element element) {
        String result = getValue(element.getOptions());
        if (!StringUtils.isEmpty(result)) {
            return result;
        } else {
            if (element.getParentElement() != null)
                return getAncestorOptionValue(element.getParentElement());
            else
                return null;
        }
    }

    private String getValue(Map options) {
        final Object result = options.get(optionKey);
        return (result != null) ? result.toString() : null;
    }

}