/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/10/26 15:58:51
 */
package org.asyrinx.joey.gen.command.rdb;

import org.asyrinx.joey.gen.model.command.ValidationError;
import org.asyrinx.joey.gen.model.pattern.Pattern;
import org.asyrinx.joey.gen.model.pattern.PatternRepository;
import org.asyrinx.joey.gen.model.rdb.TablePattern;

/**
 * @author takeshi
 */
public class ExpandPatterns extends RdbCommand {

    public void visit(TablePattern tablePattern) {
        this.log("invoked ExpandPatterns for pattern: " + tablePattern.getName());

        final Pattern pattern = PatternRepository.getInstance().get(tablePattern.getName());
        if (pattern == null) {
            addError(tablePattern, "pattern named '" + tablePattern.getName() + "' was not found.");
        }
        try {
            pattern.expand(tablePattern);
        } catch (ValidationError e) {
            addError(e.getElement(), e.getMessage());
        }
    }

}