/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/10/26 15:58:51
 */
package org.asyrinx.joey.gen.command.rdb;

import java.util.Iterator;

import org.apache.commons.lang.StringUtils;
import org.asyrinx.joey.gen.model.rdb.Column;
import org.asyrinx.joey.gen.model.rdb.ForeignKey;
import org.asyrinx.joey.gen.model.rdb.ForeignKeyEntry;
import org.asyrinx.joey.gen.model.rdb.ForeignKeyType;
import org.asyrinx.joey.gen.model.rdb.Table;

/**
 * @author takeshi
 */
public class ExtendsToFk extends RdbCommand {

    public void visit(Table table) {
        if (StringUtils.isEmpty(table.getExtends()))
            return;
        final Table extendsTable = table.getExtendsTable();
        if (extendsTable == null) {
            addError(table, "could not find table'" + table.getExtends() + "'");
        }
        final ForeignKey foreignKey = new ForeignKey(table, extendsTable.getName());
        foreignKey.setType(ForeignKeyType.EXTENDS);
        this.log(foreignKey, "create FK  ");
        if (table.hasPrimaryKey()) {
            this.log
                    .warn("table '"
                            + table.getName()
                            + "' has primary key. "
                            + "if you use hibernate, don't set primary key because primary key will be automatically generated.");
        }
        for (Iterator i = extendsTable.getPkColumns(); i.hasNext();) {
            final Column foreignColumn = (Column) i.next();
            final Column localColumn = new Column(table, foreignColumn.getName(), foreignColumn.getType(),
                    foreignColumn.getSize(), foreignColumn.isRequired(), !table.hasPrimaryKey(), foreignColumn
                            .getDefaultValue());
            localColumn.setExtended(true);
            this.log(localColumn, "create Col ");
            final ForeignKeyEntry foreignKeyEntry = new ForeignKeyEntry(foreignKey, localColumn.getName(),
                    foreignColumn.getName());
            this.log(foreignKeyEntry, "create FKEntry");
        }
    }

}