/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/08/15 18:00:19
 */
package org.asyrinx.joey.gen.command.rdb;

import java.util.Iterator;

import org.asyrinx.joey.gen.model.rdb.ForeignKey;
import org.asyrinx.joey.gen.model.rdb.ForeignKeyEntry;
import org.asyrinx.joey.gen.model.rdb.Index;
import org.asyrinx.joey.gen.model.rdb.IndexEntry;
import org.asyrinx.joey.gen.model.rdb.Table;

/**
 * @author akima
 */
public class FkToIndex extends RdbCommand {

    public void visit(ForeignKey foreignKey) {
        if (!foreignKey.isIndexed())
            return;
        if (foreignKey.getIndex() != null)
            return;
        final Table table = foreignKey.getParent();
        final Index index = new Index(table, null);
        for (final Iterator iterator = foreignKey.iterator(); iterator.hasNext();) {
            final ForeignKeyEntry entry = (ForeignKeyEntry) iterator.next();
            index.add(new IndexEntry(entry.getLocal()));
        }
        foreignKey.setIndex(index);
    }
}