/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/12/09 16:11:51
 */
package org.asyrinx.joey.gen.command.rdb;

import java.util.Iterator;

import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;
import org.asyrinx.joey.gen.model.rdb.Column;
import org.asyrinx.joey.gen.model.rdb.Table;

/**
 * @author takeshi
 */
public class PrepareCaptionColumn extends RdbCommand {

    public void visit(Table table) {
        for (int i = 0; i < predicates.length; i++) {
            final Column column = findColumn(table, predicates[i]);
            if (column != null) {
                table.setCaptionColumn(column);
                return;
            }
        }
    }

    final Predicate[] predicates = new Predicate[] { //
    new Predicate() {
        public boolean evaluate(Object obj) {
            if (!(obj instanceof Column))
                throw new UnsupportedOperationException();
            final Column column = (Column) obj;
            return column.isCaption();
        }
    }, new Predicate() {
        public boolean evaluate(Object obj) {
            if (!(obj instanceof Column))
                throw new UnsupportedOperationException();
            final Column column = (Column) obj;
            return "name".equalsIgnoreCase(column.getName());
        }
    }, new Predicate() {
        public boolean evaluate(Object obj) {
            if (!(obj instanceof Column))
                throw new UnsupportedOperationException();
            final Column column = (Column) obj;
            if (StringUtils.isEmpty(column.getName()))
                return false;
            return column.getName().toLowerCase().endsWith("name");
        }
    }

    };

    private Column findColumn(Table table, Predicate predicate) {
        for (Iterator i = table.getColumns().iterator(); i.hasNext();) {
            final Column column = (Column) i.next();
            if (predicate.evaluate(column))
                return column;
        }
        return null;
    }

}