/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/10/26 15:58:51
 */
package org.asyrinx.joey.gen.command.rdb;

import org.asyrinx.brownie.core.lang.StringUtils;
import org.asyrinx.joey.gen.model.rdb.Column;
import org.asyrinx.joey.gen.model.rdb.Database;
import org.asyrinx.joey.gen.model.rdb.ForeignKey;
import org.asyrinx.joey.gen.model.rdb.ForeignKeyEntry;
import org.asyrinx.joey.gen.model.rdb.ForeignKeyType;
import org.asyrinx.joey.gen.model.rdb.Table;

/**
 * @author takeshi
 */
public class PrepareColumnFk extends RdbCommand {

    public void visit(Column column) {
        final ForeignKeyType foreignKeyType = ForeignKeyType.get(column.getFkType());
        buildFk(column, column.getFk(), foreignKeyType);
    }

    /**
     * @param column
     */
    private ForeignKey buildFk(Column column, String foreignColumnName, ForeignKeyType fkType) {
        if (fkType == ForeignKeyType.EXTENDS)
            throw new UnsupportedOperationException("fkType must be " + ForeignKeyType.NORMAL.getName() + " or "
                    + ForeignKeyType.BIDIRECTION.getName());
        if (StringUtils.isEmpty(foreignColumnName))
            return null;
        final Table localTable = column.getParent();
        final Database db = localTable.getParent();
        final Column fkCol = db.getColumn(foreignColumnName);
        if (fkCol == null) {
            addError(column, "cannot find:" + foreignColumnName);
            return null;
        }
        final ForeignKey foreignKey = new ForeignKey(localTable, fkCol.getParent().getName());
        foreignKey.setLabel(column.getLabel());
        foreignKey.setType(fkType);
        foreignKey.setCascade(column.getFkCascade());
        new ForeignKeyEntry(foreignKey, column.getName(), fkCol.getName());
        this.log(foreignKey, "create FK from " + column.getFullName());
        return foreignKey;
    }

}