/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/10/26 15:58:51
 */
package org.asyrinx.joey.gen.command.rdb;

import org.asyrinx.joey.gen.model.rdb.Column;
import org.asyrinx.joey.gen.model.rdb.Index;
import org.asyrinx.joey.gen.model.rdb.IndexEntry;
import org.asyrinx.joey.gen.model.rdb.Table;

/**
 * @author takeshi
 */
public class PrepareColumnIndex extends RdbCommand {

    public void visit(Column column) {
        if (!column.isIndexed())
            return;
        final Table table = column.getParent();
        final Index index = new Index(table);
        new IndexEntry(index, column.getName());
        this.log(index, "create INDEX from " + column.getFullName());
    }

}