/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/10/26 15:58:51
 */
package org.asyrinx.joey.gen.command.rdb;

import org.asyrinx.joey.gen.model.rdb.Column;
import org.asyrinx.joey.gen.model.rdb.IndexEntry;
import org.asyrinx.joey.gen.model.rdb.Table;
import org.asyrinx.joey.gen.model.rdb.Unique;

/**
 * @author takeshi
 */
public class PrepareColumnUnique extends RdbCommand {

    public void visit(Column column) {
        if (!column.isUnique())
            return;
        final Table table = column.getParent();
        final Unique unique = new Unique(table);
        new IndexEntry(unique, column.getName());
        this.log(unique, "create UNIQUE from " + column.getFullName());
    }

}