/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/08/15 18:32:08
 */
package org.asyrinx.joey.gen.command.rdb;

import org.asyrinx.joey.gen.model.Element;
import org.asyrinx.joey.gen.model.EnumerationEntry;
import org.asyrinx.joey.gen.model.command.Command;
import org.asyrinx.joey.gen.model.rdb.Column;
import org.asyrinx.joey.gen.model.rdb.Database;
import org.asyrinx.joey.gen.model.rdb.Databases;
import org.asyrinx.joey.gen.model.rdb.ForeignKey;
import org.asyrinx.joey.gen.model.rdb.ForeignKeyEntry;
import org.asyrinx.joey.gen.model.rdb.Index;
import org.asyrinx.joey.gen.model.rdb.IndexEntry;
import org.asyrinx.joey.gen.model.rdb.PrimaryKey;
import org.asyrinx.joey.gen.model.rdb.RdbEnumeration;
import org.asyrinx.joey.gen.model.rdb.RdbVisitor;
import org.asyrinx.joey.gen.model.rdb.Table;
import org.asyrinx.joey.gen.model.rdb.TablePattern;
import org.asyrinx.joey.gen.model.rdb.TablePatternParam;
import org.asyrinx.joey.gen.model.rdb.Unique;
import org.asyrinx.joey.gen.model.rdb.visitor.RdbTopDownVisitor;
import org.asyrinx.joey.gen.model.rdb.visitor.RdbVisitorAdapter;

/**
 * @author akima
 */
public class RdbCommand extends Command implements RdbVisitor {

    /**
     *  
     */
    public RdbCommand() {
        super();
    }

    public void execute(Element element) {
        new RdbVisitorAdapter(new RdbTopDownVisitor(this)).visit(element);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.rdb.RdbVisitor#visit(org.asyrinx.joey.gen.model.rdb.Column)
     */
    public void visit(Column column) {
        //may be overriden by subclass
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.rdb.RdbVisitor#visit(org.asyrinx.joey.gen.model.rdb.Database)
     */
    public void visit(Database database) {
        //may be overriden by subclass
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.rdb.RdbVisitor#visit(org.asyrinx.joey.gen.model.rdb.Databases)
     */
    public void visit(Databases databases) {
        //may be overriden by subclass
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.rdb.RdbVisitor#visit(org.asyrinx.joey.gen.model.EnumerationEntry)
     */
    public void visit(EnumerationEntry enumerationEntry) {
        //may be overriden by subclass
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.rdb.RdbVisitor#visit(org.asyrinx.joey.gen.model.rdb.ForeignKey)
     */
    public void visit(ForeignKey foreignKey) {
        //may be overriden by subclass
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.rdb.RdbVisitor#visit(org.asyrinx.joey.gen.model.rdb.ForeignKeyEntry)
     */
    public void visit(ForeignKeyEntry foreignKeyEntry) {
        //may be overriden by subclass
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.rdb.RdbVisitor#visit(org.asyrinx.joey.gen.model.rdb.Index)
     */
    public void visit(Index index) {
        //may be overriden by subclass
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.rdb.RdbVisitor#visit(org.asyrinx.joey.gen.model.rdb.IndexEntry)
     */
    public void visit(IndexEntry indexEntry) {
        //may be overriden by subclass
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.rdb.RdbVisitor#visit(org.asyrinx.joey.gen.model.rdb.PrimaryKey)
     */
    public void visit(PrimaryKey primaryKey) {
        //may be overriden by subclass
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.rdb.RdbVisitor#visit(org.asyrinx.joey.gen.model.rdb.RdbEnumeration)
     */
    public void visit(RdbEnumeration enumeration) {
        //may be overriden by subclass
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.rdb.RdbVisitor#visit(org.asyrinx.joey.gen.model.rdb.Table)
     */
    public void visit(Table table) {
        //may be overriden by subclass
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.rdb.RdbVisitor#visit(org.asyrinx.joey.gen.model.rdb.TablePattern)
     */
    public void visit(TablePattern tablePattern) {
        //may be overriden by subclass
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.rdb.RdbVisitor#visit(org.asyrinx.joey.gen.model.rdb.TablePatternParam)
     */
    public void visit(TablePatternParam tablePatternParam) {
        //may be overriden by subclass
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.rdb.RdbVisitor#visit(org.asyrinx.joey.gen.model.rdb.Unique)
     */
    public void visit(Unique unique) {
        //may be overriden by subclass
    }
}