/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/08/16 6:21:18
 */
package org.asyrinx.joey.gen.command.rdb;

import org.asyrinx.joey.gen.command.rdb2java.standard.JavaOptions;
import org.asyrinx.joey.gen.model.command.CompositeCommand;

/**
 * @author akima
 */
public class StandardCommands extends CompositeCommand {

    /**
     *  
     */
    public StandardCommands() {
        super();
        initCommands();
    }

    protected void initCommands() {
        add(new CopyAncestorOption(JavaOptions.JAVA_PACKAGE));
        add(new CopyAncestorOption(JavaOptions.VIEW_CATEGORY));
        add(new CopyAncestorOption(JavaOptions.CATEGORY));
        add(new MergeDatabases());
        add(new PrepareCaptionColumn());
        add(new PreparePrimaryKey());
        add(new ExtendsToFk());
        add(new PrepareColumnFk());
        add(new PrepareColumnIndex());
        add(new PrepareColumnUnique());
        add(new FkToIndex());
        add(new ExpandPatterns());
        add(new BasicNaming());
        add(new PrepareReferrers());
        add(new SortTablesByExtends());
        add(new CheckNameOfColumn());
        add(new CheckNameOfTable());
        add(new CheckNameOfIndex());
        add(new CheckNameOfFk());
        add(new CheckNameDuplication.Tables());
        add(new CheckNameDuplication.Columns());
        add(new CheckNameDuplication.Enumerations());
        add(new CheckNameDuplication.EnumerationEntries());
        add(new CheckFkColumnType());
        add(new CheckForeignKey());
        add(new CheckIndexEntry());
        add(new CheckPrimaryKey());
    }
}