/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/10/27 2:38:38
 */
package org.asyrinx.joey.gen.command.rdb2java.standard;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import org.apache.commons.lang.StringUtils;
import org.asyrinx.joey.gen.JoeyOptions;
import org.asyrinx.joey.gen.command.rdb.CopyAncestorOption;
import org.asyrinx.joey.gen.command.rdb2java.PackagingStrategy;
import org.asyrinx.joey.gen.model.Element;
import org.asyrinx.joey.gen.model.java.Entity;
import org.asyrinx.joey.gen.model.java.JavaEnumeration;
import org.asyrinx.joey.gen.model.java.PackageType;
import org.asyrinx.joey.gen.model.java.Type;

/**
 * @author takeshi
 */
public class BasicPackaging implements PackagingStrategy {

    /**
     *  
     */
    public BasicPackaging(Map properties) {
        super();
        this.properties = properties;
    }

    private final Map properties;

    private CopyAncestorOption categoryResolver = new CopyAncestorOption(JavaOptions.CATEGORY);

    public void preparePackageNames(Entity entity) {
        final Element original = entity.getOriginal();
        if (original == null)
            return;
        final String entityCategory = categoryResolver.getOptionValue(original);
        for (Iterator i = PackageType.getElements().iterator(); i.hasNext();) {
            final PackageType packageType = (PackageType) i.next();
            final String template = (String) PACKAGE_TEMPLATES.get(packageType);
            final String packageName = getPackageHeader()
                    + StringUtils.replace(template, TEMPLATE_SYMBOL, entityCategory);
            entity.setPackage(packageType.getName(), packageName);
        }
    }

    public void preparePackageName(JavaEnumeration enum) {
        final Element original = enum.getOriginal();
        if (original == null)
            return;
        final String entityCategory = categoryResolver.getOptionValue(original);
        final String template = (String) PACKAGE_TEMPLATES.get(PackageType.ENTITY);
        final String packageName = getPackageHeader() + StringUtils.replace(template, TEMPLATE_SYMBOL, entityCategory);
        enum.setPackageName(packageName);
    }

    private static final String TEMPLATE_SYMBOL = "${category}";

    private static final Map PACKAGE_TEMPLATES = initPackageTemplates();

    private static Map initPackageTemplates() {
        final Map result = new HashMap();
        final String omHeader = "om." + TEMPLATE_SYMBOL;
        result.put(PackageType.ENTITY, omHeader + ".entity");
        result.put(PackageType.DAO, omHeader + ".dao");
        result.put(PackageType.DAO_HIBERNATE, omHeader + ".dao.hibernate");
        result.put(PackageType.SERVICE, omHeader + ".service");
        result.put(PackageType.SERVICE_IMPL, omHeader + ".service.impl");
        //
        result.put(PackageType.VIEW_SWING_COMPONENT, "swing.component." + TEMPLATE_SYMBOL);
        result.put(PackageType.VIEW_SWING_PAGE, "swing.mst." + TEMPLATE_SYMBOL);
        result.put(PackageType.VIEW_TAPESTRY_COMPONENT, "tapestry.component." + TEMPLATE_SYMBOL);
        result.put(PackageType.VIEW_TAPESTRY_PAGE, "tapestry.mst." + TEMPLATE_SYMBOL);
        //
        return result;
    }

    public String getPackageHeader() {
        if (properties == null)
            return "";
        return (String) properties.get(JoeyOptions.OPTION_BASE_PACKAGE) + Type.PACKAGE_SEPARATER;
    }
}