/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/01/13 16:19:47
 */
package org.asyrinx.joey.gen.core;

import java.io.File;

import org.apache.velocity.context.Context;

/**
 * @author takeshi
 */
public interface GenerationQuery {

    boolean canGenerate(String inputTemplate, File outputFile, Context context);

    final GenerationQuery THROUGH = new GenerationQuery() {
        public boolean canGenerate(String inputTemplate, File outputFile, Context context) {
            return true;
        }
    };

    final GenerationQuery DONT_OVERWRITE = new GenerationQuery() {
        public boolean canGenerate(String inputTemplate, File outputFile, Context context) {
            if (outputFile == null)
                return true;
            return !outputFile.exists();
        }
    };

}