/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/12/20 8:01:11
 */
package org.asyrinx.joey.gen.core;

import java.util.Map;

import ognl.MapPropertyAccessor;
import ognl.OgnlException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.context.Context;

/**
 * @author takeshi
 */
public class VelocityOgnlAccessor extends MapPropertyAccessor {

    public VelocityOgnlAccessor(Context context) {
        super();
        this.context = context;
    }

    private final Context context;

    public Object getProperty(Map context, Object target, Object name) throws OgnlException {
        final String key = toKey(name);
        if (key != null) {
            log.debug("key '" + key + "' found in velocity context.");
            return this.context.get(key);
        }
        return super.getProperty(context, target, name);
    }

    public void setProperty(Map context, Object target, Object name, Object value) throws OgnlException {
        final String key = toKey(name);
        if (key != null)
            this.context.put(key, value);
        super.setProperty(context, target, name, value);
    }

    static final Log log = LogFactory.getLog(VelocityOgnlAccessor.class);

    private static final String toKey(Object name) {
        if (name == null)
            return null;
        String key = name.toString();
        if (!key.startsWith(VelocityOgnlHelper.VELOCITY_VARIABLE_HEADER))
            return null;
        key = key.substring(VelocityOgnlHelper.VELOCITY_VARIABLE_HEADER.length());
        return key;
    }

}