/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/01/14 11:53:35
 */
package org.asyrinx.joey.gen.core.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.asyrinx.joey.gen.core.BizLogicDistiller;

/**
 * @author takeshi
 */
public class BizLogicDistillerByLine implements BizLogicDistiller {

    /**
     *  
     */
    public BizLogicDistillerByLine(String bizLogicMarkerBegin, String bizLogicMarkerEnd) {
        super();
        this.bizLogicMarkerBegin = bizLogicMarkerBegin;
        this.bizLogicMarkerEnd = bizLogicMarkerEnd;
    }

    private final String bizLogicMarkerBegin;

    private final String bizLogicMarkerEnd;

    public String getBizLogicMarkerBegin() {
        return bizLogicMarkerBegin;
    }

    public String getBizLogicMarkerEnd() {
        return bizLogicMarkerEnd;
    }

    public String distill(File source) throws IOException {
        final FileInputStream fis = new FileInputStream(source);
        final BufferedReader reader = new BufferedReader(new InputStreamReader(fis));
        final List bufferes = new ArrayList();
        //
        StringBuffer buffer = distillPart(reader);
        while (buffer != null) {
            bufferes.add(buffer);
            buffer = distillPart(reader);
        }
        return concatBuffers(bufferes);
    }

    private String concatBuffers(List buffers) {
        final StringBuffer result = new StringBuffer();
        for (Iterator i = buffers.iterator(); i.hasNext();) {
            final StringBuffer buffer = (StringBuffer) i.next();
            result.append(buffer).append("\n");
        }
        return result.toString();
    }

    /**
     * @param reader
     * @return
     * @throws IOException
     */
    private StringBuffer distillPart(BufferedReader reader) throws IOException {
        if (!skipTo(reader, getBizLogicMarkerBegin()))
            return null;
        final StringBuffer buffer = new StringBuffer();
        if (!appendTo(reader, buffer, getBizLogicMarkerEnd()))
            return null;
        else
            return buffer;
    }

    /**
     * @param reader
     * @param match
     * @throws IOException
     */
    private boolean skipTo(BufferedReader reader, String match) throws IOException {
        String line = reader.readLine();
        while (line != null) {
            if (line.trim().equals(match))
                return true;
            line = reader.readLine();
        }
        return false;
    }

    /**
     * @param reader
     * @param dest
     * @param match
     * @throws IOException
     */
    private boolean appendTo(BufferedReader reader, StringBuffer dest, String match) throws IOException {
        String line = reader.readLine();
        while (line != null) {
            if (line.trim().equals(match))
                return true;
            dest.append(line).append("\n");
            line = reader.readLine();
        }
        return false;
    }

}