/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/01/14 13:18:32
 */
package org.asyrinx.joey.gen.core.impl;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.context.Context;
import org.asyrinx.brownie.core.io.FileNameUtils;
import org.asyrinx.joey.gen.core.BizLogicDistiller;
import org.asyrinx.joey.gen.core.GenerationQuery;
import org.asyrinx.joey.gen.core.JoeyGenRuntimeException;

/**
 * @author takeshi
 */
public class BizLogicDistillerComposite implements BizLogicDistiller, GenerationQuery {

    /**
     *  
     */
    public BizLogicDistillerComposite() {
        super();
    }

    private final Map distillers = new HashMap();

    public boolean canGenerate(String inputTemplate, File outputFile, Context context) {
        context.put("bizLogic", "");
        if (outputFile == null)
            return true;
        if (!outputFile.exists())
            return true;
        final String ext = FileNameUtils.getExtension(outputFile.getName()).toLowerCase();
        if (!this.containsDistiller(ext))
            return false;
        final String distilled;
        try {
            distilled = this.distill(outputFile);
        } catch (IOException e) {
            throw new JoeyGenRuntimeException(e);
        }
        if ((distilled != null) && (!"".equals(distilled.trim()))) {
            context.put("bizLogic", distilled);
        }
        log.debug("canGenerate context.hashCode=" + context.hashCode());
        log.debug("canGenerate context['bizLogic']=" + context.get("bizLogic"));
        return true;
    }

    final Log log = LogFactory.getLog(this.getClass());

    public String distill(File source) throws IOException {
        final String ext = FileNameUtils.getExtension(source.getName());
        final BizLogicDistiller distiller = (BizLogicDistiller) distillers.get(ext);
        if (distiller != null)
            return distiller.distill(source);
        else
            return "";
    }

    public boolean containsDistiller(String ext) {
        return this.distillers.containsKey(ext.toLowerCase());
    }

    public void put(String ext, BizLogicDistiller distiller) {
        this.distillers.put(ext.toLowerCase(), distiller);
    }

}