/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/01/11 15:11:37
 */
package org.asyrinx.joey.gen.core.impl;

import java.io.File;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.texen.Generator;
import org.asyrinx.brownie.core.lang.StringUtils;
import org.asyrinx.joey.gen.core.GenerationQuery;
import org.asyrinx.joey.gen.core.JoeyVelocityGenerator;

/**
 * @author takeshi
 */
public class JoeyVelocityGeneratorImpl extends Generator implements JoeyVelocityGenerator {

    /**
     * @param propFile
     */
    public JoeyVelocityGeneratorImpl() {
        super(loadDefaultProperties());
    }

    protected void fillContextDefaults(Context context) {
        context.put("generator", this);
        context.put("outputDirectory", getOutputPath());
    }

    private static final String DEFAULT_TEXEN_PROPERTIES = "org/asyrinx/joey/gen/core/impl/texen.properties";

    protected static final Properties loadDefaultProperties() {
        final Properties result = new Properties();
        final ClassLoader classLoader = VelocityEngine.class.getClassLoader();
        try {
            InputStream inputStream = null;
            try {
                inputStream = classLoader.getResourceAsStream(DEFAULT_TEXEN_PROPERTIES);
                result.load(inputStream);
            } finally {
                if (inputStream != null)
                    inputStream.close();
            }
        } catch (Exception e) {
            System.err.println("Cannot get default properties!");
        }
        return result;
    }

    //final Log log = LogFactory.getLog(this.getClass());

    private GenerationQuery query = GenerationQuery.THROUGH;

    /*
     * (non-Javadoc)
     * 
     * @see org.apache.velocity.texen.Generator#parse(java.lang.String,
     *      org.apache.velocity.context.Context)
     */
    public String parse(String controlTemplate, Context controlContext) throws Exception {
        return super.parse(controlTemplate, controlContext);
    }

    final Log log = LogFactory.getLog(this.getClass());

    /*
     * (non-Javadoc)
     * 
     * @see org.apache.velocity.texen.Generator#parse(java.lang.String,
     *      java.lang.String, java.lang.String, java.lang.String,
     *      java.lang.String, java.lang.Object)
     */
    public String parse(String inputTemplate, String intputEncoding, String outputFile, String outputEncoding,
            String objectID, Object object) throws Exception {
        //o͐t@Cw肵Ȃꍇ
        if (StringUtils.isEmpty(outputFile))
            return super.parse(inputTemplate, intputEncoding, outputFile, outputEncoding, objectID, object);
        //o͐t@Cw肵ꍇ
        final File file = StringUtils.isEmpty(outputFile) ? null : new File(getOutputPath(), outputFile);
        if (!query.canGenerate(inputTemplate, file, this.getContext())) {
            log.debug("cannot generate file: " + file);
            return "";
        }
        return super.parse(inputTemplate, intputEncoding, outputFile, outputEncoding, objectID, object);
    }

    public GenerationQuery getQuery() {
        return query;
    }

    public void setQuery(GenerationQuery query) {
        this.query = query;
    }

    public Context getContext() {
        final Hashtable dummy = new Hashtable();
        return super.getContext(dummy);
    }

}