/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/01/13 17:58:48
 */
package org.asyrinx.joey.gen.core.impl;

import org.asyrinx.brownie.seasar.aop.CacheInterceptor;
import org.asyrinx.joey.gen.ant.DatabasesLoaderImpl;
import org.asyrinx.joey.gen.ant.ModelLoaderImpl;
import org.asyrinx.joey.gen.command.rdb2java.standard.BasicBuilder;
import org.asyrinx.joey.gen.core.BizLogicDistiller;
import org.asyrinx.joey.gen.model.rdb.xml.XmlToRdbImpl;
import org.seasar.framework.container.InitMethodDef;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.impl.ArgDefImpl;
import org.seasar.framework.container.impl.AspectDefImpl;
import org.seasar.framework.container.impl.ComponentDefImpl;
import org.seasar.framework.container.impl.InitMethodDefImpl;
import org.seasar.framework.container.impl.S2ContainerImpl;

/**
 * @author takeshi
 */
public class S2ContainerLoader {

    private static S2Container container = null;

    public static S2Container getContainer() {
        if (container == null)
            container = initContainer();
        return container;
    }

    /**
     * @return
     */
    private static S2Container initContainer() {
        //log.debug("JoeyGenerateTask#initContainer");
        //ClassLoaderdicont@CDTDǂłȂ̂ŁAdȂŃR|[lg`R[fBO
        //BrownieS2ContainerFactory.create("joey-gen.dicon",
        // this.getProject().getBaseDir().getAbsolutePath());
        final S2Container result = new S2ContainerImpl();
        result.register(XmlToRdbImpl.class);
        final ComponentDefImpl databasesLoaderDef = new ComponentDefImpl(DatabasesLoaderImpl.class);
        databasesLoaderDef.addAspectDef(new AspectDefImpl(new CacheInterceptor()));
        result.register(databasesLoaderDef);
        final ComponentDefImpl javaBuilderDef = new ComponentDefImpl(BasicBuilder.class);
        javaBuilderDef.addAspectDef(new AspectDefImpl(new CacheInterceptor()));
        result.register(javaBuilderDef);
        final ComponentDefImpl modelLoaderDef = new ComponentDefImpl(ModelLoaderImpl.class);
        result.register(modelLoaderDef);
        //
        final BizLogicDistiller javaDistiller = new BizLogicDistillerByLine( //
                "// joey user's biz logic begin", // 
                "// joey user's biz logic end");
        final BizLogicDistiller xmlDistiller = new BizLogicDistillerByLine( //
                "<!-- joey user's biz logic begin -->", // 
                "<!-- joey user's biz logic end -->");
        final ComponentDefImpl distillerCompositeDef = new ComponentDefImpl(BizLogicDistillerComposite.class);
        distillerCompositeDef.addInitMethodDef(newPutMethod("java", javaDistiller));
        distillerCompositeDef.addInitMethodDef(newPutMethod("dicon", xmlDistiller));
        distillerCompositeDef.addInitMethodDef(newPutMethod("xml", xmlDistiller));
        distillerCompositeDef.addInitMethodDef(newPutMethod("jwc", xmlDistiller));
        distillerCompositeDef.addInitMethodDef(newPutMethod("page", xmlDistiller));
        distillerCompositeDef.addInitMethodDef(newPutMethod("html", xmlDistiller));
        distillerCompositeDef.addInitMethodDef(newPutMethod("application", xmlDistiller));
        result.register(distillerCompositeDef);
        //
        final ComponentDefImpl velocityGeneratorDef = new ComponentDefImpl(JoeyVelocityGeneratorImpl.class);
        //velocityGeneratorDef.addPropertyDef(new PropertyDefImpl("query",
        // GenerationQuery.DONT_OVERWRITE));
        //velocityGeneratorDef.addPropertyDef(new PropertyDefImpl("query",
        // GenerationQuery.THROUGH));
        result.register(velocityGeneratorDef);
        return result;
    }

    public static InitMethodDef newPutMethod(String ext, BizLogicDistiller distiller) {
        final InitMethodDefImpl result = new InitMethodDefImpl("put");
        result.addArgDef(new ArgDefImpl(ext));
        result.addArgDef(new ArgDefImpl(distiller));
        return result;
    }

}