/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/02/27 1:31:17
 */
package org.asyrinx.joey.gen.hibernate;

import java.util.List;

import org.apache.commons.lang.enum.Enum;

/**
 * @author takeshi
 */
public class Cascade extends Enum {

    /**
     * @param name
     */
    protected Cascade(String name) {
        super(name);
    }

    public static final Cascade ALL = new Cascade("all");

    public static final Cascade NONE = new Cascade("none");

    public static final Cascade SAVE_UPDATE = new Cascade("save-update");

    public static final Cascade DELETE = new Cascade("delete");

    public static final Cascade ALL_DELETE_ORPHAN = new Cascade("all-delete-orphan");

    //all, none, save-update, delete, all-delete-orphan
    public static final Cascade[] CASCADES = new Cascade[] { NONE, DELETE, SAVE_UPDATE, ALL,
            ALL_DELETE_ORPHAN };

    public String getNameInToOne() {
        return NONE.getName();
    }

    public String getNameInToMany() {
        return this.getName();
    }

    public static Cascade get(String name) {
        return (Cascade) Enum.getEnum(Cascade.class, name);
    }

    public static List getList() {
        return Enum.getEnumList(Cascade.class);
    }

}