/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/11/24 17:58:41
 */
package org.asyrinx.joey.gen.hibernate;

import java.sql.Types;
import java.util.HashMap;
import java.util.Map;

import net.sf.hibernate.Hibernate;
import net.sf.hibernate.type.NullableType;

import org.apache.commons.lang.StringUtils;
import org.asyrinx.joey.gen.jdbc.JdbcUtils;
import org.asyrinx.joey.gen.model.rdb.Column;

/**
 * @author takeshi
 */
public class HibernateUtils {

    /**
     *  
     */
    public HibernateUtils() {
        super();
    }

    public static NullableType getHibernateType(String sqlTypeName, int columnSize, int decimalDigits) {
        final int sqlType = JdbcUtils.toJdbcType(sqlTypeName);
        return (sqlType == JdbcUtils.UNKNOWN_TYPE) ? null : getHibernateType(sqlType, columnSize, decimalDigits);
    }

    public static NullableType getHibernateType(int sqlType, int columnSize, int decimalDigits) {
        //logger.debug("sqlType=" + sqlType);
        //logger.debug("columnSize=" + columnSize);
        //logger.debug("decimalDigits=" + decimalDigits);
        NullableType rv = Hibernate.SERIALIZABLE;
        if (sqlType == Types.CHAR || sqlType == Types.VARCHAR) {
            rv = Hibernate.STRING;
        } else if (sqlType == Types.LONGVARCHAR) {
            rv = Hibernate.TEXT;
        } else if (sqlType == Types.BLOB) {
            rv = Hibernate.BLOB;
        } else if (sqlType == Types.CLOB) {
            rv = Hibernate.CLOB;
        } else if (sqlType == Types.FLOAT || sqlType == Types.REAL) {
            rv = Hibernate.FLOAT;
        } else if (sqlType == Types.INTEGER) {
            rv = Hibernate.INTEGER;
        } else if (sqlType == Types.DOUBLE) {
            rv = Hibernate.DOUBLE;
        } else if (sqlType == Types.DATE) {
            rv = Hibernate.DATE;
        } else if (sqlType == Types.TIMESTAMP) {
            rv = Hibernate.TIMESTAMP;
        } else if (sqlType == Types.TIME) {
            rv = Hibernate.TIME;
        } else if (sqlType == Types.BOOLEAN) {
            rv = Hibernate.BOOLEAN;
        } else if (sqlType == Types.SMALLINT) {
            rv = Hibernate.SHORT;
        } else if (sqlType == Types.BIT) {
            rv = Hibernate.BOOLEAN;
        } else if (sqlType == Types.BIGINT) {
            rv = Hibernate.LONG;
        } else if (sqlType == Types.NUMERIC || sqlType == Types.DECIMAL) {
            if (decimalDigits == 0) {
                if (columnSize == 1) {
                    rv = Hibernate.BYTE;
                } else if (columnSize < 5) {
                    rv = Hibernate.SHORT;
                } else if (columnSize < 10) {
                    rv = Hibernate.INTEGER;
                } else {
                    rv = Hibernate.LONG;
                }
            } else {
                if (columnSize < 9) {
                    rv = Hibernate.FLOAT;
                } else {
                    rv = Hibernate.DOUBLE;
                }
            }
        }
        return rv;
    }

    public static NullableType getHibernateType(Column column) {
        return getHibernateType(column.getJdbcType(), column.getSizeAsInt(), column.getDeciamlSizeAsInt());
    }

    public static String toHibernateCascade(String cascade) {
        if (StringUtils.isEmpty(cascade))
            return "none";
        if ("none".equals(cascade))
            return "none";
        if ("all".equals(cascade))
            return "all";
        if ("update".equals(cascade))
            return "save-update";
        if ("delete".equals(cascade))
            return "delete";
        return "none";
    }

    public static String getHibernateTypeName(Column column) {
        final NullableType type = getHibernateType(column);
        return getHibernateTypeName(type);
    }

    public static String getHibernateTypeName(NullableType type) {
        return (String) hibernateType2Name.get(type);
    }

    private static final Map hibernateType2Name = newHibernateType2Name();

    /**
     * @return
     */
    private static Map newHibernateType2Name() {
        final Map result = new HashMap();
        result.put(Hibernate.LONG, "LONG");
        result.put(Hibernate.SHORT, "SHORT");
        result.put(Hibernate.INTEGER, "INTEGER");
        result.put(Hibernate.BYTE, "BYTE");
        result.put(Hibernate.FLOAT, "FLOAT");
        result.put(Hibernate.DOUBLE, "DOUBLE");
        result.put(Hibernate.CHARACTER, "CHARACTER");
        result.put(Hibernate.STRING, "STRING");
        result.put(Hibernate.TIME, "TIME");
        result.put(Hibernate.DATE, "DATE");
        result.put(Hibernate.TIMESTAMP, "TIMESTAMP");
        result.put(Hibernate.BOOLEAN, "BOOLEAN");
        result.put(Hibernate.TRUE_FALSE, "TRUE_FALSE");
        result.put(Hibernate.YES_NO, "YES_NO");
        result.put(Hibernate.BIG_DECIMAL, "BIG_DECIMAL");
        result.put(Hibernate.BINARY, "BINARY");
        result.put(Hibernate.TEXT, "TEXT");
        result.put(Hibernate.BLOB, "BLOB");
        result.put(Hibernate.CLOB, "CLOB");
        result.put(Hibernate.CALENDAR, "CALENDAR");
        result.put(Hibernate.CALENDAR_DATE, "CALENDAR_DATE");
        result.put(Hibernate.LOCALE, "LOCALE");
        result.put(Hibernate.CURRENCY, "CURRENCY");
        result.put(Hibernate.TIMEZONE, "TIMEZONE");
        result.put(Hibernate.CLASS, "CLASS");
        result.put(Hibernate.SERIALIZABLE, "SERIALIZABLE");
        //result.put(Hibernate.OBJECT, "OBJECT");
        return result;
    }

}