/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/11/24 18:54:22
 */
package org.asyrinx.joey.gen.jdbc;

import java.sql.Types;
import java.util.HashMap;

import org.asyrinx.brownie.core.collection.IntegerKeyMap;
import org.asyrinx.brownie.core.collection.MapUtils;

/**
 * @author takeshi
 */
public class JdbcUtils {

    public static final int UNKNOWN_TYPE = 99999;

    /**
     *  
     */
    public JdbcUtils() {
        super();
    }

    static final IntegerKeyMap type2name;

    static final IntValueMap name2type;
    static {
        type2name = MapUtils.toIntegerKeyMap(new HashMap());
        name2type = new IntValueMap(UNKNOWN_TYPE);
        //
        add(Types.BOOLEAN, "BOOLEAN");
        add(Types.BIT, "BIT");
        add(Types.TINYINT, "TINYINT");
        add(Types.SMALLINT, "SMALLINT");
        add(Types.INTEGER, "INTEGER");
        add(Types.BIGINT, "BIGINT");
        add(Types.FLOAT, "FLOAT");
        add(Types.REAL, "REAL");
        add(Types.DOUBLE, "DOUBLE");
        add(Types.NUMERIC, "NUMERIC");
        add(Types.DECIMAL, "DECIMAL");
        add(Types.CHAR, "CHAR");
        add(Types.VARCHAR, "VARCHAR");
        add(Types.LONGVARCHAR, "LONGVARCHAR");
        add(Types.DATE, "DATE");
        add(Types.TIME, "TIME");
        add(Types.TIMESTAMP, "TIMESTAMP");
        add(Types.BINARY, "BINARY");
        add(Types.VARBINARY, "VARBINARY");
        add(Types.LONGVARBINARY, "LONGVARBINARY");
        add(Types.NULL, "NULL");
        add(Types.OTHER, "OTHER");
        add(Types.JAVA_OBJECT, "JAVA_OBJECT");
        add(Types.DISTINCT, "DISTINCT");
        add(Types.STRUCT, "STRUCT");
        add(Types.ARRAY, "ARRAY");
        add(Types.BLOB, "BLOB");
        add(Types.CLOB, "CLOB");
        add(Types.REF, "REF");
        add(Types.DATALINK, "DATALINK");
        add(Types.BOOLEAN, "BOOLEAN");
    }

    private static final void add(int jdbcType, String jdbcTypeName) {
        type2name.put(jdbcType, jdbcTypeName);
        name2type.put(jdbcTypeName, jdbcType);
    }

    public static String toJdbcTypeName(int jdbcType) {
        return (String) type2name.get(jdbcType);
    }

    public static int toJdbcType(String jdbcTypeName) {
        return name2type.getAsInt(jdbcTypeName);
    }

}

class IntValueMap extends HashMap {
    public IntValueMap(int unknown) {
        super();
        this.unknown = unknown;
    }

    private final int unknown;

    public void put(Object key, int value) {
        super.put(key, new Integer(value));
    }

    public int getAsInt(Object key) {
        final Object result = super.get(key);
        if (result instanceof Number) {
            return ((Number) result).intValue();
        } else {
            return unknown;
        }
    }

}