/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/08/10 17:00:26
 */
package org.asyrinx.joey.gen.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.asyrinx.brownie.core.lang.ClassUtils;

/**
 * @author akima
 */
public abstract class Element implements Cloneable {

    /**
     *  
     */
    public Element() {
        this(null, null);
    }

    /**
     * @param parent
     */
    public Element(Element parent) {
        this(parent, null);
    }

    /**
     * @param name
     */
    public Element(String name) {
        this(null, name);
    }

    /**
     * @param parent
     * @param name
     */
    public Element(Element parent, String name) {
        this(parent, name, null);
    }

    /**
     * @param parent
     * @param name
     */
    public Element(Element parent, String name, String label) {
        super();
        this.name = name;
        this.label = label;
        this.setParentElement(parent);
    }

    public String getElementType() {
        return ClassUtils.toShortClassName(this.getClass());
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#clone()
     */
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String getFullName() {
        return (getParentElement() == null) ? getName() : getParentElement().getFullName() + "."
                + getName();
    }

    private Element parent = null;

    /**
     * @return Returns the parent.
     */
    public Element getParentElement() {
        return parent;
    }

    /**
     * @param parent
     *            The parent to set.
     */
    protected void setParentElement(Element parent) {
        if (this.parent == parent)
            return;
        this.parent = (parent == null) ? null : (parent.isEntity()) ? parent : parent
                .getParentElement();
        if (this.parent != null)
            this.parent.add(this);
    }

    public boolean isEntity() {
        return true;
    }

    public void add(Element element) {
        if (element instanceof ElementSet) {
            //final ElementSet elementSet = (ElementSet)element;
        } else {
            throw new UnsupportedOperationException("element must not be ."
                    + element.getClass().getName() + " @" + this.getClass().getName());
        }
    }

    private String name = null;

    private String label = null;

    private String description = null;

    private Map options = null;

    /**
     * @return Returns the label.
     */
    public String getLabel() {
        return label;
    }

    /**
     * @param label
     *            The label to set.
     */
    public void setLabel(String label) {
        this.label = label;
    }

    /**
     * @return Returns the name.
     */
    public String getName() {
        return name;
    }

    /**
     * @param name
     *            The name to set.
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * @return Returns the description.
     */
    public String getDescription() {
        return description;
    }

    /**
     * @param description
     *            The description to set.
     */
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * @return Returns the options.
     */
    public Map getOptions() {
        if (this.options == null)
            this.options = new HashMap(1);
        return options;
    }

    /**
     * @param options
     *            The options to set.
     */
    public void setOptions(Map options) {
        this.options = (options != null) ? options : Collections.EMPTY_MAP;
    }

    public Object getOption(String key) {
        final Object option = getOptions().get(key);
        return (option != null) ? option : (getParentElement() == null) ? null : getParentElement()
                .getOption(key);
    }

    private Element original = null;

    /**
     * @return Returns the original.
     */
    public Element getOriginal() {
        return original;
    }

    /**
     * @param original
     *            The original to set.
     */
    public void setOriginal(Element original) {
        this.original = original;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#equals(java.lang.Object)
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof Element))
            return false;
        final Element other = (Element) obj;
        return new EqualsBuilder() //
                .append(this.getName(), other.getName()) //
                .append(this.getLabel(), other.getLabel()) //
                .append(this.getOptions(), other.getOptions()) //
                .isEquals();
    }

    public int getAncestorDepth() {
        if (getParentElement() != null)
            return getParentElement().getAncestorDepth() + 1;
        else
            return 0;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    public String toString() {
        return getFullName();
    }

}