/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/10/27 3:53:35
 */
package org.asyrinx.joey.gen.model.java;

import org.apache.commons.lang.enum.Enum;
import org.asyrinx.joey.gen.model.Element;

/**
 * @author takeshi
 */
public abstract class Constraint extends Element {

    /**
     *  
     */
    public Constraint() {
        super();
    }

    /**
     * @param parent
     */
    public Constraint(Element parent) {
        super(parent);
    }

    /**
     * @param parent
     * @param name
     */
    public Constraint(Element parent, String name) {
        super(parent, name);
    }

    /**
     * @param parent
     * @param name
     * @param label
     */
    public Constraint(Element parent, String name, String label) {
        super(parent, name, label);
    }

    /**
     * @param name
     */
    public Constraint(String name) {
        super(name);
    }

    abstract public Scope getScope();

    public static class Scope extends Enum {

        private Scope(String name) {
            super(name);
        }

        public static final Scope PROPERTY = new Scope("property");

        public static final Scope OBJECT = new Scope("object");

        public static final Scope OBJECTS = new Scope("objects");

        public static final Scope CLASS = new Scope("class");

    }
}