/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/11/07 21:24:33
 */
package org.asyrinx.joey.gen.model.java;

import org.asyrinx.joey.gen.model.ElementSet;

/**
 * @author takeshi
 */
public class EntityKey extends ElementSet {

    /**
     * @param parent
     */
    public EntityKey(Entity parent) {
        super(parent);
    }

    /**
     * @param parent
     * @param name
     */
    public EntityKey(Entity parent, String name) {
        super(parent, name);
    }

    public Entity getParent() {
        return (Entity) super.getParentElement();
    }

    private EntityKeyType keyType = EntityKeyType.INDEX;

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.ElementSet#isEntity()
     */
    public boolean isEntity() {
        return true;
    }

    public void add(EntityKeyEntry entry) {
        super.add(entry);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.ElementSet#contains(org.asyrinx.joey.gen.model.Element)
     */
    public boolean contains(EntityKeyEntry entry) {
        return super.contains(entry);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.ElementSet#getElement(int)
     */
    public EntityKeyEntry getEntry(int index) {
        return (EntityKeyEntry) super.getElement(index);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.ElementSet#get(java.lang.String)
     */
    public EntityKeyEntry getEntry(String name) {
        return (EntityKeyEntry) super.getElement(name);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.ElementSet#remove(java.lang.String)
     */
    public EntityKeyEntry removeEntry(String name) {
        return (EntityKeyEntry) super.removeElement(name);
    }

    /**
     * @return Returns the primaryKey.
     */
    public boolean isPrimaryKey() {
        return getKeyType() == EntityKeyType.PK;
    }

    public boolean isUniqueKey() {
        return getKeyType() == EntityKeyType.UNIQUE;
    }

    public EntityKeyType getKeyType() {
        return keyType;
    }

    public void setKeyType(EntityKeyType keyType) {
        this.keyType = keyType;
    }
}