/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/11/08 11:25:21
 */
package org.asyrinx.joey.gen.model.java;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import org.apache.commons.lang.StringUtils;
import org.asyrinx.joey.gen.hibernate.Cascade;
import org.asyrinx.joey.gen.model.ElementSet;

/**
 * @author takeshi
 */
public class Reference extends ElementSet implements Parameter {

    /**
     * @param parent
     */
    public Reference(Entity parent) {
        super(parent);
    }

    /**
     * @param parent
     * @param name
     */
    public Reference(Entity parent, String name) {
        super(parent, name);
    }

    private Entity referenceClass = null;

    private ReferenceType type = ReferenceType.NORMAL;

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.ElementSet#isEntity()
     */
    public boolean isEntity() {
        return true;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.Element#getParentElement()
     */
    public Entity getParent() {
        return (Entity) super.getParentElement();
    }

    public void add(ReferenceEntry entry) {
        super.add(entry);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.ElementSet#contains(org.asyrinx.joey.gen.model.Element)
     */
    public boolean contains(ReferenceEntry entry) {
        return super.contains(entry);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.ElementSet#getElement(int)
     */
    public ReferenceEntry getEntry(int index) {
        return (ReferenceEntry) super.getElement(index);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.ElementSet#get(java.lang.String)
     */
    public ReferenceEntry getEntry(String name) {
        return (ReferenceEntry) super.getElement(name);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.ElementSet#remove(java.lang.String)
     */
    public ReferenceEntry removeEntry(String name) {
        return (ReferenceEntry) super.removeElement(name);
    }

    /**
     * @return
     */
    public String getReferenceClassName() {
        return (getReferenceClass() == null) ? null : getReferenceClass().getName();
    }

    /**
     * @return Returns the referenceClass.
     */
    public Entity getReferenceClass() {
        return referenceClass;
    }

    /**
     * @param referenceClass
     *            The referenceClass to set.
     */
    public void setReferenceClass(Entity referenceClass) {
        this.referenceClass = referenceClass;
    }

    /**
     * @param property
     * @return
     */
    public boolean containsAsLocal(Property property) {
        for (Iterator i = this.iterator(); i.hasNext();) {
            final ReferenceEntry entry = (ReferenceEntry) i.next();
            if (entry.getLocal() == property)
                return true;
        }
        return false;
    }

    /**
     * @param property
     * @return
     */
    public boolean containsAsForeign(Property property) {
        for (Iterator i = this.iterator(); i.hasNext();) {
            final ReferenceEntry entry = (ReferenceEntry) i.next();
            if (entry.getForeign() == property)
                return true;
        }
        return false;
    }

    public String getPropertyNameInReferred(boolean plural) {
        final String className = getParent().getName();
        String relatedByCol = "";
        final Set otherRefs = this.getParent().getParent().findReferences(getParent(),
                getReferenceClass());
        if (otherRefs.size() > 1) {
            for (Iterator i = this.iterator(); i.hasNext();) {
                final ReferenceEntry entry = (ReferenceEntry) i.next();
                if (!entry.getLocal().getReferencesContainedAsLocal().isEmpty())
                    relatedByCol = relatedByCol + entry.getLocal().getCapitalizedName();
            }
        }
        if (StringUtils.isEmpty(relatedByCol)) {
            return (plural) ? StringUtils.uncapitalize(className + "s") : StringUtils
                    .uncapitalize(className);
        }
        //final String refClassName = getReferenceClassName();
        final String s = ((plural) ? "s" : "") + "RelatedBy";
        return StringUtils.uncapitalize(className) + s + relatedByCol;
    }

    public String getPropertyNameInReferred() {
        return getPropertyNameInReferred(true);
    }

    public String getPropertyNameInLocal() {
        final Entity foreignClass = this.getReferenceClass();
        final String className = foreignClass.getName();
        String relCol = "";
        final List otherRefs = new ArrayList();
        for (Entity current = this.getParent(); current != null; current = current.getSuperClass()) {
            otherRefs.addAll(current.getReferencesContainedAsForeign(foreignClass));
        }
        if (otherRefs.size() > 1) {
            for (Iterator i = this.iterator(); i.hasNext();) {
                final ReferenceEntry entry = (ReferenceEntry) i.next();
                if ((!entry.getLocal().getReferencesContainedAsLocal().isEmpty())
                        || (getReferenceClass() == this.getParent()))
                    relCol = relCol + entry.getLocal().getCapitalizedName();
            }
        }
        if (StringUtils.isNotEmpty(relCol))
            relCol = "RelatedBy" + relCol;
        return StringUtils.uncapitalize(className + relCol);
    }

    /**
     * @return Returns the type.
     */
    public ReferenceType getType() {
        return type;
    }

    /**
     * @param type
     *            The type to set.
     */
    public void setType(ReferenceType type) {
        this.type = type;
    }

    public boolean isForward() {
        return getType() != ReferenceType.EXTENDS;
    }

    public boolean isBackward() {
        return getType() == ReferenceType.BIDIRECTION;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.java.Parameter#getParamName()
     */
    public String getParamName() {
        return this.getPropertyNameInLocal();
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.java.Parameter#getParamType()
     */
    public Type getParamType() {
        return this.getReferenceClass();
    }

    private Cascade cascade = null;

    public Cascade getCascade() {
        return cascade;
    }

    public void setCascade(Cascade cascade) {
        this.cascade = cascade;
    }

    public String getCaption() {
        final StringBuffer result = new StringBuffer();
        result.append(getParent().getName());
        result.append("-->");
        result.append(getReferenceClass().getName());
        result.append("[");
        for (Iterator i = this.iterator(); i.hasNext();) {
            final ReferenceEntry entry = (ReferenceEntry) i.next();
            result.append(entry.getLocal().getName());
            result.append("-->");
            result.append(entry.getForeign().getName());
            if (i.hasNext())
                result.append(" ");
        }
        result.append("]");
        return result.toString();
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.Element#toString()
     */
    public String toString() {
        return getCaption();
    }

}