/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/11/08 12:59:29
 */
package org.asyrinx.joey.gen.model.java;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.asyrinx.joey.gen.model.ElementSet;

/**
 * @author takeshi
 */
public class ReferenceSet extends ElementSet {

    /**
     * @param parent
     */
    public ReferenceSet(Entity parent) {
        super(parent);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.Element#isEntity()
     */
    public boolean isEntity() {
        return false;
    }

    public void add(Reference reference) {
        super.add(reference);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.ElementSet#contains(org.asyrinx.joey.gen.model.Element)
     */
    public boolean contains(Reference reference) {
        return super.contains(reference);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.ElementSet#getElement(int)
     */
    public Reference getReference(int index) {
        return (Reference) super.getElement(index);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.ElementSet#get(java.lang.String)
     */
    public Reference getReference(String name) {
        return (Reference) super.getElement(name);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.ElementSet#remove(java.lang.String)
     */
    public Reference removeReference(String name) {
        return (Reference) super.removeElement(name);
    }

    /**
     * @param property
     * @return
     */
    public List getReferencesContainedAsLocal(Property property) {
        final List result = new ArrayList();
        for (Iterator i = this.iterator(); i.hasNext();) {
            final Reference reference = (Reference) i.next();
            if (reference.containsAsLocal(property))
                result.add(reference);
        }
        return result;
    }

    /**
     * @param property
     * @return
     */
    public List getReferencesContainedAsForeign(Entity javaClass) {
        final List result = new ArrayList();
        for (Iterator i = this.iterator(); i.hasNext();) {
            final Reference reference = (Reference) i.next();
            if (reference.getReferenceClass() == javaClass)
                result.add(reference);
        }
        return result;
    }

    /**
     * @param javaClass
     * @param dest
     */
    public void findReferencesContainedAsForeign(Entity javaClass, List dest) {
        for (Iterator i = this.iterator(); i.hasNext();) {
            final Reference reference = (Reference) i.next();
            if (reference.getType() == ReferenceType.EXTENDS)
                continue;
            if (reference.getReferenceClass() == javaClass)
                dest.add(reference);
        }
    }

    /**
     * @param javaClass
     * @param dest
     */
    public void findReferencesContainedAsLocal(Entity javaClass, List dest) {
        for (Iterator i = this.iterator(); i.hasNext();) {
            final Reference reference = (Reference) i.next();
            if (reference.getType() == ReferenceType.EXTENDS)
                continue;
            if (reference.getParent() == javaClass)
                dest.add(reference);
        }
    }
}