/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/02/25 20:24:48
 */
package org.asyrinx.joey.gen.model.java.classes;

import java.util.HashMap;
import java.util.Map;

import org.asyrinx.joey.gen.model.EnumerationEntry;
import org.asyrinx.joey.gen.model.java.JavaEnumeration;
import org.asyrinx.joey.gen.model.rdb.RdbEnumeration;

/**
 * @author takeshi
 */
public class JoeyRuntimeClass {

    private static final Map rdbEnums = new HashMap();

    private static final Map javaEnums = new HashMap();

    private static RdbEnumeration createRdbBooleanEnum() {
        final RdbEnumeration result = new RdbEnumeration();
        result.setName("BooleanEnum");
        result.setValueType("INTEGER");
        result.setLabel("BOOLEAN");
        new EnumerationEntry(result, "0", "false", "false");
        new EnumerationEntry(result, "1", "true", "true");
        final String key = result.getName();
        rdbEnums.put(key, result);
        return result;
    }

    private static JavaEnumeration createJavaBooleanEnum() {
        final JavaEnumeration result = new JavaEnumeration();
        result.setName("BooleanEnum");
        result.setPackageName("org.asyrinx.brownie.core.lang.enum.util");
        result.setValueType("int");
        result.setValueTypeObj(PrimitiveType.INT);
        result.setLabel("BOOLEAN");
        result.setOriginal(RDB_BOOLEAN_ENUM);
        new EnumerationEntry(result, "0", "false", "false");
        new EnumerationEntry(result, "1", "true", "true");
        javaEnums.put(result.getName(), result);
        return result;
    }

    public static RdbEnumeration getRdbEnum(String enumName) {
        return (RdbEnumeration) rdbEnums.get(enumName);
    }

    public static JavaEnumeration getJavaEnum(String enumName) {
        return (JavaEnumeration) javaEnums.get(enumName);
    }

    public static final RdbEnumeration RDB_BOOLEAN_ENUM = createRdbBooleanEnum();

    public static final JavaEnumeration JAVA_BOOLEAN_ENUM = createJavaBooleanEnum();

}