/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/08/14 19:46:14
 */
package org.asyrinx.joey.gen.model.java.classes;

import org.asyrinx.joey.gen.model.java.Type;
import org.asyrinx.joey.gen.model.java.TypeCategory;

/**
 * @author akima
 */
public abstract class PrimitiveType extends EmbeddedClass {

    public static final String PACKAGE = "java.lang";

    /**
     * @param className
     * @param category
     */
    public PrimitiveType(String className, TypeCategory category) {
        super(PACKAGE, className, category);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.java.Type#getFullName()
     */
    public String getFqn() {
        return getName();
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.java.Type#getPackage()
     */
    public String getPackage() {
        return null;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.java.Type#isPrimitive()
     */
    public boolean isPrimitive() {
        return true;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.java.Type#toPrimitive()
     */
    public Type toPrimitive() {
        return this;
    }

    public static final PrimitiveType BOOLEAN = new PrimitiveType("boolean", TypeCategory.BOOLEAN) {
        public Type toClass() {
            return PrimitiveWrapper.BOOLEAN;
        }
    };

    public static final PrimitiveType CHAR = new PrimitiveType("char", TypeCategory.STRING) {
        public Type toClass() {
            return PrimitiveWrapper.CHARACTER;
        }
    };

    public static final PrimitiveType BYTE = new PrimitiveType("byte", TypeCategory.NUMBER) {
        public Type toClass() {
            return PrimitiveWrapper.BYTE;
        }
    };

    public static final PrimitiveType SHORT = new PrimitiveType("short", TypeCategory.NUMBER) {
        public Type toClass() {
            return PrimitiveWrapper.SHORT;
        }
    };

    public static final PrimitiveType INT = new PrimitiveType("int", TypeCategory.NUMBER) {
        public Type toClass() {
            return PrimitiveWrapper.INTEGER;
        }
    };

    public static final PrimitiveType LONG = new PrimitiveType("long", TypeCategory.NUMBER) {
        public Type toClass() {
            return PrimitiveWrapper.LONG;
        }
    };

    public static final PrimitiveType FLOAT = new PrimitiveType("float", TypeCategory.NUMBER) {
        public Type toClass() {
            return PrimitiveWrapper.FLOAT;
        }
    };

    public static final PrimitiveType DOUBLE = new PrimitiveType("double", TypeCategory.NUMBER) {
        public Type toClass() {
            return PrimitiveWrapper.DOUBLE;
        }
    };

}