/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/08/14 19:50:46
 */
package org.asyrinx.joey.gen.model.java.classes;

import org.asyrinx.joey.gen.model.java.Type;
import org.asyrinx.joey.gen.model.java.TypeCategory;

/**
 * @author akima
 */
public abstract class PrimitiveWrapper extends EmbeddedClass {

    /**
     *  
     */
    protected PrimitiveWrapper(String name, TypeCategory category) {
        super("java.lang", name, category);
    }

    public static final PrimitiveWrapper BOOLEAN = new PrimitiveWrapper("Boolean", TypeCategory.BOOLEAN) {
        public Type toPrimitive() {
            return PrimitiveType.BOOLEAN;
        }
    };

    public static final PrimitiveWrapper CHARACTER = new PrimitiveWrapper("Character", TypeCategory.STRING) {
        public Type toPrimitive() {
            return PrimitiveType.CHAR;
        }
    };

    public static final PrimitiveWrapper BYTE = new PrimitiveWrapper("Byte", TypeCategory.NUMBER) {
        public Type toPrimitive() {
            return PrimitiveType.BYTE;
        }
    };

    public static final PrimitiveWrapper SHORT = new PrimitiveWrapper("Short", TypeCategory.NUMBER) {
        public Type toPrimitive() {
            return PrimitiveType.SHORT;
        }
    };

    public static final PrimitiveWrapper INTEGER = new PrimitiveWrapper("Integer", TypeCategory.NUMBER) {
        public Type toPrimitive() {
            return PrimitiveType.INT;
        }
    };

    public static final PrimitiveWrapper LONG = new PrimitiveWrapper("Long", TypeCategory.NUMBER) {
        public Type toPrimitive() {
            return PrimitiveType.LONG;
        }
    };

    public static final PrimitiveWrapper FLOAT = new PrimitiveWrapper("Float", TypeCategory.NUMBER) {
        public Type toPrimitive() {
            return PrimitiveType.FLOAT;
        }
    };

    public static final PrimitiveWrapper DOUBLE = new PrimitiveWrapper("Double", TypeCategory.NUMBER) {
        public Type toPrimitive() {
            return PrimitiveType.DOUBLE;
        }
    };

}