/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/11/09 12:41:40
 */
package org.asyrinx.joey.gen.model.java.visitor;

import java.util.Iterator;

import org.asyrinx.joey.gen.model.java.AppDomain;
import org.asyrinx.joey.gen.model.java.Entity;
import org.asyrinx.joey.gen.model.java.EntityKey;
import org.asyrinx.joey.gen.model.java.JavaEnumeration;
import org.asyrinx.joey.gen.model.java.JavaVisitor;
import org.asyrinx.joey.gen.model.java.Property;
import org.asyrinx.joey.gen.model.java.Reference;

/**
 * @author takeshi
 */
public class JavaTopDownVisitor extends JavaVisitorWrapper {

    /**
     * @param wrapped
     */
    public JavaTopDownVisitor(JavaVisitor wrapped) {
        super(wrapped);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.java.JavaVisitor#visit(org.asyrinx.joey.gen.model.java.AppDomain)
     */
    public void visit(AppDomain appDomain) {
        super.visit(appDomain);
        for (Iterator i = appDomain.getEnumerations().iterator(); i.hasNext();) {
            final JavaEnumeration element = (JavaEnumeration) i.next();
            visit(element);
        }
        for (Iterator i = appDomain.getClasses().iterator(); i.hasNext();) {
            final Entity element = (Entity) i.next();
            visit(element);
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.java.JavaVisitor#visit(org.asyrinx.joey.gen.model.java.Entity)
     */
    public void visit(Entity javaClass) {
        super.visit(javaClass);
        for (Iterator i = javaClass.getProperties().iterator(); i.hasNext();) {
            final Property element = (Property) i.next();
            visit(element);
        }
        for (Iterator i = javaClass.getKeys().iterator(); i.hasNext();) {
            final EntityKey element = (EntityKey) i.next();
            visit(element);
        }
        for (Iterator i = javaClass.getReferences().iterator(); i.hasNext();) {
            final Reference element = (Reference) i.next();
            visit(element);
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.java.JavaVisitor#visit(org.asyrinx.joey.gen.model.java.EntityKey)
     */
    public void visit(EntityKey javaClassKey) {
        super.visit(javaClassKey);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.java.JavaVisitor#visit(org.asyrinx.joey.gen.model.java.JavaEnumeration)
     */
    public void visit(JavaEnumeration enum) {
        super.visit(enum);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.java.JavaVisitor#visit(org.asyrinx.joey.gen.model.java.Property)
     */
    public void visit(Property property) {
        super.visit(property);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.java.JavaVisitor#visit(org.asyrinx.joey.gen.model.java.Reference)
     */
    public void visit(Reference reference) {
        super.visit(reference);
    }
}