/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/11/09 12:36:03
 */
package org.asyrinx.joey.gen.model.java.visitor;

import org.asyrinx.joey.gen.model.Element;
import org.asyrinx.joey.gen.model.ElementVisitor;
import org.asyrinx.joey.gen.model.java.AppDomain;
import org.asyrinx.joey.gen.model.java.Entity;
import org.asyrinx.joey.gen.model.java.EntityKey;
import org.asyrinx.joey.gen.model.java.JavaEnumeration;
import org.asyrinx.joey.gen.model.java.JavaVisitor;
import org.asyrinx.joey.gen.model.java.Property;
import org.asyrinx.joey.gen.model.java.Reference;

/**
 * @author takeshi
 */
public class JavaVisitorAdapter implements ElementVisitor {

    /**
     *  
     */
    public JavaVisitorAdapter(JavaVisitor adaptee) {
        super();
        this.adaptee = adaptee;
    }

    protected final JavaVisitor adaptee;

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.ElementVisitor#visit(org.asyrinx.joey.gen.model.Element)
     */
    public void visit(Element element) {
        if (element instanceof AppDomain)
            adaptee.visit((AppDomain) element);
        else if (element instanceof Entity)
            adaptee.visit((Entity) element);
        else if (element instanceof EntityKey)
            adaptee.visit((EntityKey) element);
        else if (element instanceof JavaEnumeration)
            adaptee.visit((JavaEnumeration) element);
        else if (element instanceof Property)
            adaptee.visit((Property) element);
        else if (element instanceof Reference)
            adaptee.visit((Reference) element);
        else
            this.visit(element);
    }
}