/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/11/09 12:39:21
 */
package org.asyrinx.joey.gen.model.java.visitor;

import org.asyrinx.joey.gen.model.java.AppDomain;
import org.asyrinx.joey.gen.model.java.Entity;
import org.asyrinx.joey.gen.model.java.EntityKey;
import org.asyrinx.joey.gen.model.java.JavaEnumeration;
import org.asyrinx.joey.gen.model.java.JavaVisitor;
import org.asyrinx.joey.gen.model.java.Property;
import org.asyrinx.joey.gen.model.java.Reference;

/**
 * @author takeshi
 */
public class JavaVisitorWrapper implements JavaVisitor {

    /**
     *  
     */
    public JavaVisitorWrapper(JavaVisitor wrapped) {
        super();
        this.wrapped = wrapped;
    }

    protected final JavaVisitor wrapped;

    /**
     * @param appDomain
     */
    public void visit(AppDomain appDomain) {
        wrapped.visit(appDomain);
    }

    /**
     * @param javaClass
     */
    public void visit(Entity javaClass) {
        wrapped.visit(javaClass);
    }

    /**
     * @param javaClassKey
     */
    public void visit(EntityKey javaClassKey) {
        wrapped.visit(javaClassKey);
    }

    /**
     * @param enum
     */
    public void visit(JavaEnumeration enum) {
        wrapped.visit(enum);
    }

    /**
     * @param property
     */
    public void visit(Property property) {
        wrapped.visit(property);
    }

    /**
     * @param reference
     */
    public void visit(Reference reference) {
        wrapped.visit(reference);
    }
}