/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/12/27 17:58:58
 */
package org.asyrinx.joey.gen.model.pattern;

import java.util.HashMap;
import java.util.Map;

/**
 * @author takeshi
 */
public class PatternRepository {

    /**
     *  
     */
    protected PatternRepository() {
        super();
    }

    private final Map patternMap = initPatternMap();

    private static final PatternRepository instance = new PatternRepository();

    public static PatternRepository getInstance() {
        return instance;
    }

    private static Map initPatternMap() {
        final Map result = new HashMap();
        result.put("logical_deletable", new SingleColumnPattern("deleted", "INTEGER",
                "BooleanEnum", "폜"));
        result.put("created_date", new SingleColumnPattern("created_date", "TIMESTAMP", "쐬"));
        result.put("updated_date", new SingleColumnPattern("updated_date", "TIMESTAMP", "XV"));
        return result;
    }

    public void add(String name, Pattern pattern) {
        patternMap.put(name, pattern);
    }

    public Pattern get(String name) {
        return (Pattern) patternMap.get(name);
    }

}