/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/12/27 17:56:49
 */
package org.asyrinx.joey.gen.model.pattern;

import org.asyrinx.joey.gen.model.command.ValidationError;
import org.asyrinx.joey.gen.model.rdb.Column;
import org.asyrinx.joey.gen.model.rdb.Table;
import org.asyrinx.joey.gen.model.rdb.TablePattern;
import org.asyrinx.joey.gen.model.rdb.TablePatternParam;

/**
 * @author takeshi
 */
public class SingleColumnPattern implements Pattern {

    public SingleColumnPattern(String defaultColumnName, String columnType, String label) {
        this(defaultColumnName, columnType, null, label);
    }

    public SingleColumnPattern(String defaultColumnName, String columnType, String enum,
            String label) {
        this.defaultColumnName = defaultColumnName;
        this.columnType = columnType;
        this.enum = enum;
        this.label = label;
    }

    final String defaultColumnName;

    final String columnType;

    final String enum;

    final String label;

    public void expand(TablePattern tablePattern) {
        final TablePatternParam param;
        if (tablePattern.isEmpty()) {
            param = new TablePatternParam(tablePattern, "columnName", null);
            param.setValue(this.defaultColumnName);
        } else {
            param = tablePattern.getParam("columnName");
            if (param == null)
                throw new ValidationError("param named 'columnName' was not found", tablePattern);
        }
        final String columnName = param.getValue();
        final Table table = tablePattern.getParent();
        final Column column = new Column(table, columnName, columnType);
        column.setLabel(this.label);
        column.setRequired(true);
        column.setEnum(this.enum);
    }

    public boolean isTarget(String templatePath) {
        return "om/service".equals(templatePath);
    }
}