/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/08/12 18:37:54
 */
package org.asyrinx.joey.gen.model.rdb;

import java.util.Iterator;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.asyrinx.brownie.core.lang.StringUtils;
import org.asyrinx.joey.gen.model.Element;

import test.org.asyrinx.joey.gen.model.rdb.Constants;

/**
 * @author akima
 */
public class Databases extends Element {

    /**
     *  
     */
    public Databases() {
        super();
    }

    /**
     *  
     */
    public Databases(String name) {
        super(name);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.Element#add(org.asyrinx.joey.gen.model.Element)
     */
    public void add(Element element) {
        if (element instanceof Database)
            databases.add((Database) element);
        else
            super.add(element);
    }

    private final DatabaseSet databases = new DatabaseSet(this);

    /**
     * @return Returns the databases.
     */
    public DatabaseSet getDatabases() {
        return databases;
    }

    public void appendDatabases(Databases dbs) {
        for (Iterator i = dbs.getDatabases().iterator(); i.hasNext();) {
            final Database db = (Database) i.next();
            this.add(db);
        }
    }

    /**
     * @param columnName
     * @return
     */
    public Column getColumn(String columnName) {
        final String[] nameParts = StringUtils.tokenizeToArray(columnName, Constants.ELEMENTS_DELIMITER);
        if (nameParts.length == 3) {
            final Database db = getDatabases().getDatabase(nameParts[0]);
            return (db == null) ? null : db.getColumn(nameParts[1], nameParts[2]);
        }
        return null;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#equals(java.lang.Object)
     */
    public boolean equals(Object obj) {
        if (!super.equals(obj))
            return false;
        if (!(obj instanceof Databases))
            return false;
        final Databases other = (Databases) obj;
        return new EqualsBuilder() //
                .append(this.getDatabases(), other.getDatabases()) //
                .isEquals();
    }
}