/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/08/10 17:15:47
 */
package org.asyrinx.joey.gen.model.rdb;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.asyrinx.joey.gen.model.Element;

/**
 * @author akima
 */
public class ForeignKeyEntry extends Element {

    /**
     *  
     */
    public ForeignKeyEntry() {
        super();
    }

    /**
     *  
     */
    public ForeignKeyEntry(String local, String foreign) {
        this(null, local, foreign);
    }

    /**
     *  
     */
    public ForeignKeyEntry(ForeignKey parent, String local, String foreign) {
        super(parent);
        this.local = local;
        this.foreign = foreign;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.Element#getParentElement()
     */
    public ForeignKey getParent() {
        return (ForeignKey) super.getParentElement();
    }

    private String local = null;

    private String foreign = null;

    /**
     * @return Returns the foreign.
     */
    public String getForeign() {
        return foreign;
    }

    /**
     * @param foreign
     *            The foreign to set.
     */
    public void setForeign(String foreign) {
        this.foreign = foreign;
    }

    /**
     * @return Returns the local.
     */
    public String getLocal() {
        return local;
    }

    /**
     * @param local
     *            The local to set.
     */
    public void setLocal(String local) {
        this.local = local;
    }

    public Column getLocalColumn() {
        if (getParent() == null)
            return null;
        final Table table = getParent().getLocal();
        return table.getColumns().getColumn(getLocal());
    }

    public Column getForeignColumn() {
        if (getParent() == null)
            return null;
        final Table table = getParent().getForeignTable();
        return table.getColumns().getColumn(getForeign());
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#equals(java.lang.Object)
     */
    public boolean equals(Object obj) {
        if (!super.equals(obj))
            return false;
        if (!(obj instanceof ForeignKeyEntry))
            return false;
        final ForeignKeyEntry other = (ForeignKeyEntry) obj;
        return new EqualsBuilder() //
                .append(this.getLocal(), other.getLocal()) //
                .append(this.getForeign(), other.getForeign()) //
                .isEquals();
    }
}