/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/08/15 15:14:06
 */
package org.asyrinx.joey.gen.model.rdb.visitor;

import org.asyrinx.joey.gen.model.Element;
import org.asyrinx.joey.gen.model.EnumerationEntry;
import org.asyrinx.joey.gen.model.ElementVisitor;
import org.asyrinx.joey.gen.model.rdb.Column;
import org.asyrinx.joey.gen.model.rdb.Database;
import org.asyrinx.joey.gen.model.rdb.Databases;
import org.asyrinx.joey.gen.model.rdb.RdbEnumeration;
import org.asyrinx.joey.gen.model.rdb.ForeignKey;
import org.asyrinx.joey.gen.model.rdb.ForeignKeyEntry;
import org.asyrinx.joey.gen.model.rdb.Index;
import org.asyrinx.joey.gen.model.rdb.IndexEntry;
import org.asyrinx.joey.gen.model.rdb.RdbVisitor;
import org.asyrinx.joey.gen.model.rdb.Table;
import org.asyrinx.joey.gen.model.rdb.TablePattern;
import org.asyrinx.joey.gen.model.rdb.TablePatternParam;
import org.asyrinx.joey.gen.model.rdb.Unique;

/**
 * @author akima
 */
public class RdbVisitorAdapter implements ElementVisitor {

    /**
     *  
     */
    public RdbVisitorAdapter(RdbVisitor adaptee) {
        super();
        this.adaptee = adaptee;
    }

    private final RdbVisitor adaptee;

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.ElementVisitor#visit(org.asyrinx.joey.gen.model.Element)
     */
    public void visit(Element element) {
        if (element instanceof Column)
            adaptee.visit((Column) element);
        else if (element instanceof Database)
            adaptee.visit((Database) element);
        else if (element instanceof Databases)
            adaptee.visit((Databases) element);
        else if (element instanceof RdbEnumeration)
            adaptee.visit((RdbEnumeration) element);
        else if (element instanceof EnumerationEntry)
            adaptee.visit((EnumerationEntry) element);
        else if (element instanceof ForeignKey)
            adaptee.visit((ForeignKey) element);
        else if (element instanceof ForeignKeyEntry)
            adaptee.visit((ForeignKeyEntry) element);
        else if (element instanceof Unique)
            adaptee.visit((Unique) element);
        else if (element instanceof Index)
            adaptee.visit((Index) element);
        else if (element instanceof IndexEntry)
            adaptee.visit((IndexEntry) element);
        else if (element instanceof Table)
            adaptee.visit((Table) element);
        else if (element instanceof TablePattern)
            adaptee.visit((TablePattern) element);
        else if (element instanceof TablePatternParam)
            adaptee.visit((TablePatternParam) element);
        else
            this.visit(element);
    }

}