/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/01/25 21:51:29
 */
package test.org.asyrinx.joey.gen.command.java;

import org.asyrinx.joey.gen.command.java.CheckNameOfProperty;
import org.asyrinx.joey.gen.command.rdb2java.standard.BasicBuilder;
import org.asyrinx.joey.gen.model.java.AppDomain;
import org.asyrinx.joey.gen.model.java.Entity;
import org.asyrinx.joey.gen.model.java.Property;
import org.asyrinx.joey.gen.model.rdb.Column;
import org.asyrinx.joey.gen.model.rdb.Database;
import org.asyrinx.joey.gen.model.rdb.Databases;
import org.asyrinx.joey.gen.model.rdb.Table;

import junit.framework.TestCase;

/**
 * @author takeshi
 */
public class CheckNameOfPropertyTest extends TestCase {

    public static void main(String[] args) {
        junit.swingui.TestRunner.run(CheckNameOfPropertyTest.class);
    }

    final CheckNameOfProperty checker = new CheckNameOfProperty();

    public void testCheckNameOfProperty() {
        final AppDomain domain = new AppDomain("domain");
        //
        final Entity entity1 = new Entity(domain, "entity1");
        new Property(entity1).setName("property1");
        new Property(entity1).setName("property2");
        //
        final Entity entity2 = new Entity(domain, "entity2");
        entity2.setSuperClass(entity1);
        new Property(entity2).setName("property3");
        new Property(entity2).setName("property2");
        //
        checker.setStrict(false);
        checker.execute(domain);
        assertEquals(1, checker.getErrors().size());
    }

    public void testCheckNameOfProperty1() {
        final AppDomain domain = new AppDomain("domain");
        //
        final Entity entity1 = new Entity(domain, "entity1");
        new Property(entity1).setName("property1");
        new Property(entity1).setName("property2");
        //
        final Entity entity2 = new Entity(domain, "entity2");
        entity2.setSuperClass(entity1);
        final Property extendedKey = new Property(entity2);
        extendedKey.setName("property1");
        extendedKey.setExtended(true);
        new Property(entity2).setName("property3");
        //
        checker.setStrict(false);
        checker.execute(domain);
        assertEquals(0, checker.getErrors().size());
    }

    public void testCheckNameOfProperty2() {
        final Databases databases = new Databases("dbs");
        final Database database = new Database(databases, "db");
        //
        final Table table1 = new Table(database, "table1");
        new Column(table1, "column1", "BIGINT", "0", true, true);
        new Column(table1, "column2", "VARCHAR");
        //
        final Table table2 = new Table(database, "table2");
        table2.setExtends("table1");
        new Column(table2, "column3", "VARCHAR");
        //
        final BasicBuilder builder = new BasicBuilder();
        try {
            builder.execute(databases);
        } catch (Throwable e) {
            e.printStackTrace();
            fail();
        }
    }

}