/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/08/16 4:14:06
 */
package test.org.asyrinx.joey.gen.command.rdb;

import junit.framework.TestCase;

import org.asyrinx.joey.gen.command.rdb.CheckFkColumnType;
import org.asyrinx.joey.gen.model.command.ValidationError;
import org.asyrinx.joey.gen.model.rdb.Column;
import org.asyrinx.joey.gen.model.rdb.Database;
import org.asyrinx.joey.gen.model.rdb.ForeignKey;
import org.asyrinx.joey.gen.model.rdb.ForeignKeyEntry;
import org.asyrinx.joey.gen.model.rdb.Table;

/**
 * @author akima
 */
public class CheckFkColumnTypeTest extends TestCase {

    public static void main(String[] args) {
        junit.swingui.TestRunner.run(CheckFkColumnTypeTest.class);
    }

    public void testNoraml() {
        final Database database = new Database();
        final Table table1 = new Table(database, "table1");
        final Column column1_1 = new Column(table1, "col1-1", "BIGINT");
        final Column column1_2 = new Column(table1, "col1-2", "INTEGER");
        final Column column1_3 = new Column(table1, "col1-3", "VARCHAR", "20");
        //
        final Table table2 = new Table(database, "table2");
        final Column column2_1 = new Column(table2, "col2-1", "INTEGER");
        final Column column2_2 = new Column(table2, "col2-2", "DATE");
        final Column column2_3 = new Column(table2, "col2-3", "VARCHAR", "30");
        final ForeignKey foreignKey2_1 = new ForeignKey(table2, "table1");
        final ForeignKeyEntry entry2_1_1 = new ForeignKeyEntry(foreignKey2_1, "col2-1", "col1-1");
        final ForeignKey foreignKey2_2 = new ForeignKey(table2, "table1");
        final ForeignKeyEntry entry2_2_1 = new ForeignKeyEntry(foreignKey2_1, "col2-3", "col1-3");
        //
        try {
            new CheckFkColumnType().execute(database);
            fail();
        } catch (ValidationError e) {
            assertEquals(entry2_1_1, e.getElement());
        } catch (Throwable e) {
            e.printStackTrace();
            fail();
        }
        //
        column2_1.setType("BIGINT");
        try {
            new CheckFkColumnType().execute(database);
            fail();
        } catch (ValidationError e) {
            assertEquals(entry2_2_1, e.getElement());
        } catch (Throwable e) {
            e.printStackTrace();
            fail();
        }
        column2_3.setSize("20");
        try {
            new CheckFkColumnType().execute(database);
        } catch (Throwable e) {
            e.printStackTrace();
            fail();
        }
    }

}