/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/08/16 3:17:22
 */
package test.org.asyrinx.joey.gen.command.rdb;

import junit.framework.TestCase;

import org.asyrinx.joey.gen.command.rdb.CheckForeignKey;
import org.asyrinx.joey.gen.model.command.ValidationError;
import org.asyrinx.joey.gen.model.rdb.Column;
import org.asyrinx.joey.gen.model.rdb.Database;
import org.asyrinx.joey.gen.model.rdb.ForeignKey;
import org.asyrinx.joey.gen.model.rdb.ForeignKeyEntry;
import org.asyrinx.joey.gen.model.rdb.Table;

/**
 * @author akima
 */
public class CheckForeignKeyTest extends TestCase {

    public static void main(String[] args) {
        junit.swingui.TestRunner.run(CheckForeignKeyTest.class);
    }

    public void testNormal() {
        final Database database = new Database();
        final Table table1 = new Table(database, "table1");
        new Column(table1, "col1-1", "int");
        new Column(table1, "col1-2", "int");
        new Column(table1, "col1-3", "int");
        //
        final Table table2 = new Table(database, "table2");
        new Column(table2, "col2-1", "int");
        new Column(table2, "col2-2", "int");
        new Column(table2, "col2-3", "int");
        final ForeignKey foreignKey2_1 = new ForeignKey(table2, "");
        final ForeignKeyEntry entry2_1_1 = new ForeignKeyEntry(foreignKey2_1, "col2", "col1");
        foreignKey2_1.setIndexed(false);
        //
        try {
            new CheckForeignKey().execute(database);
            //database.accept(new RdbVisitorAdapter(new RdbTopDownVisitor(new
            // CheckForeignKey())));
            fail();
        } catch (ValidationError e) {
            assertEquals(foreignKey2_1, e.getElement());
        } catch (Throwable e) {
            e.printStackTrace();
            fail();
        }
        //
        foreignKey2_1.setForeign("t1");
        try {
            new CheckForeignKey().execute(database);
            fail();
        } catch (ValidationError e) {
            assertEquals(foreignKey2_1, e.getElement());
        } catch (Throwable e) {
            e.printStackTrace();
            fail();
        }
        //
        foreignKey2_1.setForeign("table1");
        try {
            new CheckForeignKey().execute(database);
            fail();
        } catch (ValidationError e) {
            assertEquals(entry2_1_1, e.getElement());
        } catch (Throwable e) {
            e.printStackTrace();
            fail();
        }
        //
        entry2_1_1.setLocal("col2-1");
        try {
            new CheckForeignKey().execute(database);
            fail();
        } catch (ValidationError e) {
            assertEquals(entry2_1_1, e.getElement());
        } catch (Throwable e) {
            e.printStackTrace();
            fail();
        }
        //
        entry2_1_1.setForeign("col1-1");
        try {
            new CheckForeignKey().execute(database);
        } catch (Throwable e) {
            e.printStackTrace();
            fail();
        }

    }

}