/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/08/16 1:31:47
 */
package test.org.asyrinx.joey.gen.command.rdb;

import junit.framework.TestCase;

import org.asyrinx.joey.gen.command.rdb.FkToIndex;
import org.asyrinx.joey.gen.model.rdb.Column;
import org.asyrinx.joey.gen.model.rdb.Database;
import org.asyrinx.joey.gen.model.rdb.ForeignKey;
import org.asyrinx.joey.gen.model.rdb.ForeignKeyEntry;
import org.asyrinx.joey.gen.model.rdb.Index;
import org.asyrinx.joey.gen.model.rdb.IndexEntry;
import org.asyrinx.joey.gen.model.rdb.Table;
import org.asyrinx.joey.gen.model.rdb.visitor.RdbVisitorAdapter;
import org.asyrinx.joey.gen.model.rdb.visitor.RdbTopDownVisitor;

/**
 * @author akima
 */
public class FkToIndexTest extends TestCase {

    public static void main(String[] args) {
        junit.swingui.TestRunner.run(FkToIndexTest.class);
    }

    public void testExtend() {
        final Database database = new Database();
        final Table table1 = new Table(database, "table1");
        new Column(table1, "col1-1", "int");
        new Column(table1, "col1-2", "int");
        new Column(table1, "col1-3", "int");
        final Index index1_1 = new Index(table1, "named_index_1");
        index1_1.add(new IndexEntry("col1-2"));
        final Index index1_2 = new Index(table1);
        index1_2.add(new IndexEntry("col1-3"));
        index1_2.add(new IndexEntry("col1-1"));
        //
        final Table table2 = new Table(database, "table2");
        new Column(table2, "col2-1", "int");
        new Column(table2, "col2-2", "int");
        new Column(table2, "col2-3", "int");
        final ForeignKey foreignKey2_1 = new ForeignKey(table2, table1.getName());
        foreignKey2_1.add(new ForeignKeyEntry("col2-1", "col1-1"));
        foreignKey2_1.setIndexed(false);
        final ForeignKey foreignKey2_2 = new ForeignKey(table2, "named_fk", table1.getName());
        foreignKey2_2.setIndexed(true);
        foreignKey2_2.add(new ForeignKeyEntry("col2-2", "col1-2"));
        foreignKey2_2.add(new ForeignKeyEntry("col2-3", "col1-3"));
        //
        new FkToIndex().execute(database);
        //database.accept(new RdbVisitorAdapter(new RdbTopDownVisitor(new
        // FkToIndex())));
        //
        assertEquals(1, table2.getIndexes().size());
        final Index index = table2.getIndexes().getIndex(0);
        assertEquals(null, foreignKey2_1.getIndex());
        assertEquals(index, foreignKey2_2.getIndex());
        assertEquals(foreignKey2_2, table2.findForeignKey(index));
        //
        assertEquals(2, index.size());
        final IndexEntry entry0 = index.getEntry(0);
        final IndexEntry entry1 = index.getEntry(1);
        assertEquals("col2-2", entry0.getName());
        assertEquals("col2-3", entry1.getName());
    }

}