/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/08/14 20:53:09
 */
package test.org.asyrinx.joey.gen.command.rdb2java.standard;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import junit.framework.TestCase;

import org.asyrinx.joey.gen.command.rdb2java.standard.BasicBuilder;
import org.asyrinx.joey.gen.command.rdb2java.standard.JavaOptions;
import org.asyrinx.joey.gen.model.EnumerationEntry;
import org.asyrinx.joey.gen.model.java.AppDomain;
import org.asyrinx.joey.gen.model.java.Entity;
import org.asyrinx.joey.gen.model.java.EntityKey;
import org.asyrinx.joey.gen.model.java.EntityKeyType;
import org.asyrinx.joey.gen.model.java.JavaEnumeration;
import org.asyrinx.joey.gen.model.java.Parameter;
import org.asyrinx.joey.gen.model.java.Property;
import org.asyrinx.joey.gen.model.java.Reference;
import org.asyrinx.joey.gen.model.java.classes.JavaLangClass;
import org.asyrinx.joey.gen.model.java.classes.JavaUtilClass;
import org.asyrinx.joey.gen.model.java.classes.JoeyRuntimeClass;
import org.asyrinx.joey.gen.model.java.classes.PrimitiveType;
import org.asyrinx.joey.gen.model.java.classes.PrimitiveWrapper;
import org.asyrinx.joey.gen.model.rdb.Column;
import org.asyrinx.joey.gen.model.rdb.Database;
import org.asyrinx.joey.gen.model.rdb.Databases;
import org.asyrinx.joey.gen.model.rdb.Index;
import org.asyrinx.joey.gen.model.rdb.IndexEntry;
import org.asyrinx.joey.gen.model.rdb.RdbEnumeration;
import org.asyrinx.joey.gen.model.rdb.Table;
import org.asyrinx.joey.gen.model.rdb.TablePattern;
import org.asyrinx.joey.gen.model.rdb.Unique;

/**
 * @author akima
 */
public class BasicBuilderTest extends TestCase {

    public static void main(String[] args) {
        junit.swingui.TestRunner.run(BasicBuilderTest.class);
    }

    public void testExecute() {

        final Databases databases = new Databases();
        final Database db1 = new Database(databases, "db1");
        //db1.getOptions().put("javaPackage", "org.asyrinx.joey.sample");
        db1.getOptions().put("category", "package1");
        //
        final RdbEnumeration e_party_type = new RdbEnumeration(db1, "PartyType");
        e_party_type.setValueType("Integer");
        e_party_type.setLabel("p[eB^");
        new EnumerationEntry(e_party_type, "1", "individual", "l");
        new EnumerationEntry(e_party_type, "2", "corporation", "@l");
        //
        final Table t_party = new Table(db1, "party", "p[eB");
        new Column(t_party, "party_id", "BIGINT", "0", true, true, "0");
        new Column(t_party, "name", "VARCHAR", "20", true, false, null);
        new TablePattern(t_party, "logical_deletable", "");
        new TablePattern(t_party, "created_date", "");
        new TablePattern(t_party, "updated_date", "");
        final Column col_party_type = new Column(t_party, "party_type", "PartyType", "0", true,
                false, "corporation");
        col_party_type.setEnum("PartyType");
        //
        final BasicBuilder builder = new BasicBuilder();
        final Map props = new HashMap();
        props.put("joey-gen.proj.base.package", "org.asyrinx.joey.sample");
        builder.setProperties(props);
        final AppDomain domain = builder.execute(databases);
        //
        assertEquals(1, domain.getClasses().size());
        assertEquals(1, domain.getEnumerations().size());
        //
        final JavaEnumeration je_party_type = domain.getEnumerations().getEnumeration(0);
        assertEquals("PartyType", je_party_type.getName());
        assertEquals("p[eB^", je_party_type.getLabel());
        assertEquals(PrimitiveWrapper.INTEGER, je_party_type.getValueTypeObj());
        assertEquals(2, je_party_type.size());
        assertEquals("1", je_party_type.getEntry(0).getValue());
        assertEquals("individual", je_party_type.getEntry(0).getName());
        assertEquals("l", je_party_type.getEntry(0).getLabel());
        assertEquals("2", je_party_type.getEntry(1).getValue());
        assertEquals("corporation", je_party_type.getEntry(1).getName());
        assertEquals("@l", je_party_type.getEntry(1).getLabel());
        //
        final Entity c_party = domain.getClasses().getJavaType(0);
        assertEquals("Party", c_party.getName());
        assertEquals("org.asyrinx.joey.sample.om.package1.entity", c_party.getPackage());
        assertEquals("org.asyrinx.joey.sample.om.package1.entity.Party", c_party.getFqn());
        assertEquals("p[eB", c_party.getLabel());
        assertEquals(6, c_party.getProperties().size());
        final Property p_party_id = c_party.getProperties().getProperty(0);
        assertEquals("partyId", p_party_id.getName());
        assertEquals("long", p_party_id.getTypeName());
        assertEquals(PrimitiveType.LONG, p_party_id.getType());
        assertEquals(0, p_party_id.getMaxLength());
        assertEquals(true, p_party_id.isRequired());
        assertEquals("0", p_party_id.getDefaultValue());
        final Property p_name = c_party.getProperties().getProperty(1);
        assertEquals("name", p_name.getName());
        assertEquals("String", p_name.getTypeName());
        assertEquals(JavaLangClass.STRING, p_name.getType());
        assertEquals(20, p_name.getMaxLength());
        assertEquals(true, p_name.isRequired());
        assertEquals("null", p_name.getDefaultValue());
        final Property p_party_type = c_party.getProperties().getProperty(2);
        assertEquals("partyType", p_party_type.getName());
        assertEquals("PartyType", p_party_type.getTypeName());
        assertEquals(je_party_type, p_party_type.getType());
        assertEquals(0, p_party_type.getMaxLength());
        assertEquals(true, p_party_type.isRequired());
        assertEquals("corporation", p_party_type.getDefaultValue());
        final Property p_party_deleted = c_party.getProperties().getProperty(3);
        assertEquals("deleted", p_party_deleted.getName());
        assertEquals("int", p_party_deleted.getTypeName());
        assertEquals(PrimitiveType.INT, p_party_deleted.getType());
        assertEquals(0, p_party_deleted.getMaxLength());
        assertEquals(true, p_party_deleted.isRequired());
        assertEquals("0", p_party_deleted.getDefaultValue());
        final Property p_party_created = c_party.getProperties().getProperty(4);
        assertEquals("createdDate", p_party_created.getName());
        assertEquals("Date", p_party_created.getTypeName());
        assertEquals(JavaUtilClass.DATE, p_party_created.getType());
        assertEquals(0, p_party_created.getMaxLength());
        assertEquals(true, p_party_created.isRequired());
        assertEquals("null", p_party_created.getDefaultValue());
        final Property p_party_updated = c_party.getProperties().getProperty(5);
        assertEquals("updatedDate", p_party_updated.getName());
        assertEquals("Date", p_party_updated.getTypeName());
        assertEquals(JavaUtilClass.DATE, p_party_updated.getType());
        assertEquals(0, p_party_updated.getMaxLength());
        assertEquals(true, p_party_updated.isRequired());
        assertEquals("null", p_party_updated.getDefaultValue());
        //
        assertEquals("partyTypeEnum", p_party_type.getEnumPropertyName());
        assertEquals(je_party_type, p_party_type.getEnumType());
    }

    public void testKeys() {
        final Databases databases = new Databases();
        final Database db1 = new Database(databases, "db1");
        db1.getOptions().put("javaPackage", "org.asyrinx.joey.sample");
        //
        final Table t_party = new Table(db1, "party", "p[eB");
        new Column(t_party, "party_id", "BIGINT", "0", true, true, "0");
        new Column(t_party, "name", "VARCHAR", "20", true, false, null);
        //
        final Table t_role = new Table(db1, "role", "[");
        new Column(t_role, "role_id", "BIGINT", "0", true, true, "0");
        final Column colPartyId = new Column(t_role, "party_id", "BIGINT", "0", true, false, "0");
        colPartyId.setFk("party.party_id");
        //
        final Table t_user = new Table(db1, "system_user", "VXe[U");
        t_user.setExtends("role");
        new Column(t_user, "system_user_id", "BIGINT", "0", true, true, "0");
        new Column(t_user, "values", "VARCHAR", "20", true, false, null);
        //
        final BasicBuilder builder = new BasicBuilder();
        final Map props = new HashMap();
        props.put("joey-gen.proj.base.package", "org.asyrinx.joey.sample");
        builder.setProperties(props);
        final AppDomain domain = builder.execute(databases);
        //
        assertEquals(1, t_role.getForeignKeys().size());
        //
        assertEquals(3, domain.getClasses().size());
        assertEquals(0, domain.getEnumerations().size());
        //
        final Entity c_party = domain.getClasses().getJavaType(0);
        assertEquals("Party", c_party.getName());
        assertEquals("org.asyrinx.joey.sample.om.db1.entity", c_party.getPackage());
        assertEquals("org.asyrinx.joey.sample.om.db1.entity.Party", c_party.getFqn());
        assertEquals("p[eB", c_party.getLabel());
        assertEquals(2, c_party.getProperties().size());
        final Property p_party_id = c_party.getProperties().getProperty(0);
        assertEquals("partyId", p_party_id.getName());
        assertEquals("long", p_party_id.getTypeName());
        assertEquals(PrimitiveType.LONG, p_party_id.getType());
        assertEquals(0, p_party_id.getMaxLength());
        assertEquals(true, p_party_id.isRequired());
        assertEquals("0", p_party_id.getDefaultValue());
        final Property p_name = c_party.getProperties().getProperty(1);
        assertEquals("name", p_name.getName());
        assertEquals("String", p_name.getTypeName());
        assertEquals(JavaLangClass.STRING, p_name.getType());
        assertEquals(20, p_name.getMaxLength());
        assertEquals(true, p_name.isRequired());
        assertEquals("null", p_name.getDefaultValue());
        final EntityKey pk_party = c_party.getPrimaryKey();
        assertEquals(1, pk_party.size());
        assertEquals(p_party_id, pk_party.getEntry(0).getProperty());

        //
        final Entity c_role = domain.getClasses().getJavaType(1);
        assertEquals("Role", c_role.getName());
        assertEquals("org.asyrinx.joey.sample.om.db1.entity", c_role.getPackage());
        assertEquals("org.asyrinx.joey.sample.om.db1.entity.Role", c_role.getFqn());
        assertEquals("[", c_role.getLabel());
        assertEquals(2, c_role.getProperties().size());
        final Property p_role_id = c_role.getProperties().getProperty(0);
        assertEquals("roleId", p_role_id.getName());
        assertEquals("long", p_role_id.getTypeName());
        assertEquals(PrimitiveType.LONG, p_role_id.getType());
        assertEquals(0, p_role_id.getMaxLength());
        assertEquals(true, p_role_id.isRequired());
        assertEquals("0", p_role_id.getDefaultValue());
        final Property p_role_party_id = c_role.getProperties().getProperty(1);
        assertEquals("partyId", p_role_party_id.getName());
        assertEquals("long", p_role_party_id.getTypeName());
        assertEquals(PrimitiveType.LONG, p_role_party_id.getType());
        assertEquals(0, p_role_party_id.getMaxLength());
        assertEquals(true, p_role_party_id.isRequired());
        assertEquals("0", p_role_party_id.getDefaultValue());
        //
        final List role_allProperties = c_role.getPropertiesAll();
        assertEquals(2, role_allProperties.size());
        assertEquals(p_role_id, role_allProperties.get(0));
        assertEquals(p_role_party_id, role_allProperties.get(1));
        //
        final Entity c_system_user = domain.getClasses().getJavaType(2);
        assertEquals("SystemUser", c_system_user.getName());
        assertEquals("org.asyrinx.joey.sample.om.db1.entity", c_system_user.getPackage());
        assertEquals("org.asyrinx.joey.sample.om.db1.entity.SystemUser", c_system_user.getFqn());
        assertEquals("VXe[U", c_system_user.getLabel());
        assertEquals(3, c_system_user.getProperties().size());
        assertEquals(c_role, c_system_user.getSuperClass());
        final Property p_system_user_id = c_system_user.getProperties().getProperty(0);
        assertEquals("systemUserId", p_system_user_id.getName());
        assertEquals("long", p_system_user_id.getTypeName());
        assertEquals(PrimitiveType.LONG, p_system_user_id.getType());
        assertEquals(0, p_system_user_id.getMaxLength());
        assertEquals(true, p_system_user_id.isRequired());
        assertEquals("0", p_system_user_id.getDefaultValue());
        final Property p_values = c_system_user.getProperties().getProperty(1);
        assertEquals("values", p_values.getName());
        assertEquals("String", p_values.getTypeName());
        assertEquals(JavaLangClass.STRING, p_values.getType());
        assertEquals(20, p_values.getMaxLength());
        assertEquals(true, p_values.isRequired());
        assertEquals("null", p_values.getDefaultValue());
        // ̃vpeB͌pɂ͂Ȃ̂ŁAȂBΉJ͐
        //final Property p_system_user_role_id =
        // c_system_user.getProperties().getProperty(2);
        //assertEquals("roleId", p_system_user_role_id.getName());
        //assertEquals("long", p_system_user_role_id.getType());
        //assertEquals(PrimitiveType.LONG,
        // p_system_user_role_id.getJavaType());
        //assertEquals(0, p_system_user_role_id.getMaxLength());
        //assertEquals(true, p_system_user_role_id.isRequired());
        //assertEquals("0", p_system_user_role_id.getDefaultValue());
        final List systemUser_allProperties = c_system_user.getPropertiesAll();
        assertEquals(5, systemUser_allProperties.size());
        assertEquals(p_role_id, systemUser_allProperties.get(0));
        assertEquals(p_role_party_id, systemUser_allProperties.get(1));
        assertEquals(p_system_user_id, systemUser_allProperties.get(2));
        assertEquals(p_values, systemUser_allProperties.get(3));
        //
        assertEquals(1, c_role.getReferences().size());
        final Reference ref_role_to_party = c_role.getReferences().getReference(0);
        assertEquals("Party", ref_role_to_party.getReferenceClassName());
        assertEquals(c_party, ref_role_to_party.getReferenceClass());
        assertEquals(p_role_party_id, ref_role_to_party.getEntry(0).getLocal());
        assertEquals(p_party_id, ref_role_to_party.getEntry(0).getForeign());
        assertEquals(1, p_role_party_id.getReferencesContainedAsLocal().size());
        assertEquals(0, p_role_party_id.getReferencesContainedAsForeign().size());
        assertEquals(0, p_party_id.getReferencesContainedAsLocal().size());
        assertEquals(1, p_party_id.getReferencesContainedAsForeign().size());
        //
        assertEquals("party", ref_role_to_party.getPropertyNameInLocal());
        assertEquals("roles", ref_role_to_party.getPropertyNameInReferred());
        assertEquals("role", ref_role_to_party.getPropertyNameInReferred(false));
        //
        assertEquals(1, c_party.getReferreds().size());
        assertEquals(ref_role_to_party, c_party.getReferreds().get(0));
        assertEquals(0, c_role.getReferreds().size());
    }

    public void testReference() {
        final Databases databases = new Databases();
        final Database db1 = new Database(databases, "db1");
        db1.getOptions().put("javaPackage", "org.asyrinx.joey.sample");
        //
        final Table t_party = new Table(db1, "party", "p[eB");
        new Column(t_party, "party_id", "BIGINT", "0", true, true, "0");
        new Column(t_party, "name", "VARCHAR", "20", true, false, null);
        //
        final Table t_relation = new Table(db1, "relation", "֌W");
        new Column(t_relation, "relation_id", "BIGINT", "0", true, true, "0");
        final Column colOriginPartyId = new Column(t_relation, "origin_party_id", "BIGINT", "0",
                true, false, "0");
        final Column colDestPartyId = new Column(t_relation, "dest_party_id", "BIGINT", "0", true,
                false, "0");
        colOriginPartyId.setFk("party.party_id");
        colDestPartyId.setFk("party.party_id");
        //
        final BasicBuilder builder = new BasicBuilder();
        final Map props = new HashMap();
        props.put("joey-gen.proj.base.package", "org.asyrinx.joey.sample");
        builder.setProperties(props);
        final AppDomain domain = builder.execute(databases);
        //
        assertEquals(2, t_relation.getForeignKeys().size());
        //
        assertEquals(2, domain.getClasses().size());
        //
        final Entity c_party = domain.getClasses().getJavaType(0);
        assertEquals("Party", c_party.getName());
        assertEquals("org.asyrinx.joey.sample.om.db1.entity", c_party.getPackage());
        assertEquals("org.asyrinx.joey.sample.om.db1.entity.Party", c_party.getFqn());
        assertEquals("p[eB", c_party.getLabel());
        assertEquals(2, c_party.getProperties().size());
        final Property p_party_id = c_party.getProperties().getProperty(0);
        assertEquals("partyId", p_party_id.getName());
        assertEquals("long", p_party_id.getTypeName());
        assertEquals(PrimitiveType.LONG, p_party_id.getType());
        assertEquals(0, p_party_id.getMaxLength());
        assertEquals(true, p_party_id.isRequired());
        assertEquals("0", p_party_id.getDefaultValue());
        final Property p_name = c_party.getProperties().getProperty(1);
        assertEquals("name", p_name.getName());
        assertEquals("String", p_name.getTypeName());
        assertEquals(JavaLangClass.STRING, p_name.getType());
        assertEquals(20, p_name.getMaxLength());
        assertEquals(true, p_name.isRequired());
        assertEquals("null", p_name.getDefaultValue());
        final EntityKey pk_party = c_party.getPrimaryKey();
        assertEquals(1, pk_party.size());
        assertEquals(p_party_id, pk_party.getEntry(0).getProperty());
        //
        final Entity c_relation = domain.getClasses().getJavaType(1);
        assertEquals("Relation", c_relation.getName());
        assertEquals("org.asyrinx.joey.sample.om.db1.entity", c_relation.getPackage());
        assertEquals("org.asyrinx.joey.sample.om.db1.entity.Relation", c_relation.getFqn());
        assertEquals("֌W", c_relation.getLabel());
        assertEquals(3, c_relation.getProperties().size());
        final Property p_role_id = c_relation.getProperties().getProperty(0);
        assertEquals("relationId", p_role_id.getName());
        assertEquals("long", p_role_id.getTypeName());
        assertEquals(PrimitiveType.LONG, p_role_id.getType());
        assertEquals(0, p_role_id.getMaxLength());
        assertEquals(true, p_role_id.isRequired());
        assertEquals("0", p_role_id.getDefaultValue());
        final Property p_origin_party_id = c_relation.getProperties().getProperty(1);
        assertEquals("originPartyId", p_origin_party_id.getName());
        assertEquals("long", p_origin_party_id.getTypeName());
        assertEquals(PrimitiveType.LONG, p_origin_party_id.getType());
        assertEquals(0, p_origin_party_id.getMaxLength());
        assertEquals(true, p_origin_party_id.isRequired());
        assertEquals("0", p_origin_party_id.getDefaultValue());
        final Property p_dest_party_id = c_relation.getProperties().getProperty(2);
        assertEquals("destPartyId", p_dest_party_id.getName());
        assertEquals("long", p_dest_party_id.getTypeName());
        assertEquals(PrimitiveType.LONG, p_dest_party_id.getType());
        assertEquals(0, p_dest_party_id.getMaxLength());
        assertEquals(true, p_dest_party_id.isRequired());
        assertEquals("0", p_dest_party_id.getDefaultValue());
        //
        assertEquals(2, c_relation.getReferences().size());
        assertEquals(1, p_origin_party_id.getReferencesContainedAsLocal().size());
        assertEquals(0, p_origin_party_id.getReferencesContainedAsForeign().size());
        assertEquals(0, p_party_id.getReferencesContainedAsLocal().size());
        assertEquals(2, p_party_id.getReferencesContainedAsForeign().size());
        final Reference ref_origin_to_party = c_relation.getReferences().getReference(0);
        assertEquals("Party", ref_origin_to_party.getReferenceClassName());
        assertEquals(c_party, ref_origin_to_party.getReferenceClass());
        assertEquals(p_origin_party_id, ref_origin_to_party.getEntry(0).getLocal());
        assertEquals(p_party_id, ref_origin_to_party.getEntry(0).getForeign());
        assertEquals("partyRelatedByOriginPartyId", ref_origin_to_party.getPropertyNameInLocal());
        assertEquals("relationsRelatedByOriginPartyId", ref_origin_to_party
                .getPropertyNameInReferred());
        assertEquals("relationRelatedByOriginPartyId", ref_origin_to_party
                .getPropertyNameInReferred(false));
        //
        final Reference ref_dest_to_party = c_relation.getReferences().getReference(1);
        assertEquals("Party", ref_dest_to_party.getReferenceClassName());
        assertEquals(c_party, ref_dest_to_party.getReferenceClass());
        assertEquals(p_dest_party_id, ref_dest_to_party.getEntry(0).getLocal());
        assertEquals(p_party_id, ref_dest_to_party.getEntry(0).getForeign());
        assertEquals("partyRelatedByDestPartyId", ref_dest_to_party.getPropertyNameInLocal());
        assertEquals("relationsRelatedByDestPartyId", ref_dest_to_party.getPropertyNameInReferred());
        assertEquals("relationRelatedByDestPartyId", ref_dest_to_party
                .getPropertyNameInReferred(false));
        //
        assertEquals(1, c_relation.getReferenceEntities().size());
        assertEquals(c_party, c_relation.getReferenceEntities().iterator().next());
        //
        assertEquals(2, c_party.getReferreds().size());
        assertEquals(ref_origin_to_party, c_party.getReferreds().get(0));
        assertEquals(ref_dest_to_party, c_party.getReferreds().get(1));
        assertEquals(0, c_relation.getReferreds().size());
    }

    public void testPackaging() {

        final Databases databases = new Databases();
        final Database db1 = new Database(databases, "db1");
        //db1.getOptions().put("javaPackage",
        // "org.asyrinx.joey.${packageType}.party");
        db1.getOptions().put(JavaOptions.CATEGORY, "party");
        final Table t_party = new Table(db1, "party", "p[eB");
        new Column(t_party, "party_id", "BIGINT", "0", true, true, "0");
        //
        final Database db1_ = new Database(databases, "db1");
        //db1_.getOptions().put("javaPackage",
        // "org.asyrinx.joey.${packageType}.report");
        db1_.getOptions().put(JavaOptions.CATEGORY, "report");
        final Table t_report = new Table(db1_, "report", "");
        final Column col_reporter_id = new Column(t_report, "reporter_id", "BIGINT", "0", true,
                true, "0");
        col_reporter_id.setFk("party.party_id");
        final Table t_notify = new Table(db1_, "notify", "ʒm");
        new Column(t_notify, "notify_id", "BIGINT", "0", true, true);
        //
        final BasicBuilder builder = new BasicBuilder();
        final Map props = new HashMap();
        props.put("joey-gen.proj.base.package", "org.asyrinx.joey.sample");
        builder.setProperties(props);
        final AppDomain domain = builder.execute(databases);
        //
        assertEquals(1, databases.getDatabases().size());
        assertEquals(db1, databases.getDatabases().getDatabase(0));
        //
        assertEquals(3, domain.getClasses().size());
        final Entity ety_party = domain.getClasses().getJavaType(0);
        final Entity ety_report = domain.getClasses().getJavaType(1);
        final Entity ety_notify = domain.getClasses().getJavaType(2);
        assertEquals("Party", ety_party.getName());
        assertEquals("Report", ety_report.getName());
        assertEquals("Notify", ety_notify.getName());
        //
        assertEquals("org.asyrinx.joey.sample.om.party.entity", ety_party.getPackageName());
        assertEquals("org.asyrinx.joey.sample.om.report.entity", ety_report.getPackageName());
        assertEquals("org.asyrinx.joey.sample.om.report.entity", ety_notify.getPackageName());
        //
        assertEquals("org.asyrinx.joey.sample.om.party.dao", ety_party.getPackage("dao"));
        assertEquals("org.asyrinx.joey.sample.om.report.dao", ety_report.getPackage("dao"));
        assertEquals("org.asyrinx.joey.sample.om.report.dao", ety_notify.getPackage("dao"));
        //
        assertEquals(1, ety_party.getImports().size());
        assertEquals("org.asyrinx.joey.sample.om.report.entity.Report", ety_party.getImports()
                .iterator().next());
        assertEquals(1, ety_report.getImports().size());
        assertEquals("org.asyrinx.joey.sample.om.party.entity.Party", ety_report.getImports()
                .iterator().next());
    }

    public void testConstructorParams() {
        final Databases databases = new Databases();
        final Database db1 = new Database(databases, "db1");
        //
        final Table t_party = new Table(db1, "party", "p[eB");
        new Column(t_party, "party_id", "BIGINT", "0", true, true, "0");
        new Column(t_party, "name", "VARCHAR", "20", true, false, null);
        //
        final Table t_role = new Table(db1, "role", "[");
        new Column(t_role, "role_id", "BIGINT", "0", true, true, "0");
        final Column colPartyId = new Column(t_role, "party_id", "BIGINT", "0", true, false, "0");
        colPartyId.setFk("party.party_id");
        //
        final Table t_user = new Table(db1, "system_user", "VXe[U");
        t_user.setExtends("role");
        new Column(t_user, "values", "VARCHAR", "20", true, false, null);
        //
        final BasicBuilder builder = new BasicBuilder();
        final AppDomain domain = builder.execute(databases);
        //
        assertEquals(3, domain.getClasses().size());
        final Entity e_party = domain.getClasses().getJavaType("Party");
        final Entity e_role = domain.getClasses().getJavaType("Role");
        final Entity e_user = domain.getClasses().getJavaType("SystemUser");
        assertNotNull(e_party);
        assertNotNull(e_role);
        assertNotNull(e_user);
        {
            final List e_party_params = e_party.getConstructorParams();
            assertEquals(2, e_party_params.size());
            assertEquals(Property.class, e_party_params.get(0).getClass());
            assertEquals(Property.class, e_party_params.get(1).getClass());
            final Parameter e_party_params_id = (Parameter) e_party_params.get(0);
            assertEquals("partyId", e_party_params_id.getParamName());
            assertEquals("long", e_party_params_id.getParamType().getName());
            final Parameter e_party_params_name = (Parameter) e_party_params.get(1);
            assertEquals("name", e_party_params_name.getParamName());
            assertEquals("String", e_party_params_name.getParamType().getName());
        }
        {
            final List e_role_params = e_role.getConstructorParams();
            assertEquals(2, e_role_params.size());
            assertEquals(Property.class, e_role_params.get(0).getClass());
            assertEquals(Reference.class, e_role_params.get(1).getClass());
            final Parameter e_party_params_id = (Parameter) e_role_params.get(0);
            assertEquals("roleId", e_party_params_id.getParamName());
            assertEquals("long", e_party_params_id.getParamType().getName());
            final Parameter e_party_params_party = (Parameter) e_role_params.get(1);
            assertEquals("party", e_party_params_party.getParamName());
            assertEquals("Party", e_party_params_party.getParamType().getName());
        }
        {
            final List e_user_params = e_user.getConstructorParams();
            assertEquals(3, e_user_params.size());
            assertEquals(Property.class, e_user_params.get(0).getClass());
            assertEquals(Reference.class, e_user_params.get(1).getClass());
            assertEquals(Property.class, e_user_params.get(2).getClass());
            final Parameter e_party_params_id = (Parameter) e_user_params.get(0);
            assertEquals("roleId", e_party_params_id.getParamName());
            assertEquals("long", e_party_params_id.getParamType().getName());
            final Parameter e_party_params_party = (Parameter) e_user_params.get(1);
            assertEquals("party", e_party_params_party.getParamName());
            assertEquals("Party", e_party_params_party.getParamType().getName());
            final Parameter e_party_params_name = (Parameter) e_user_params.get(2);
            assertEquals("values", e_party_params_name.getParamName());
            assertEquals("String", e_party_params_name.getParamType().getName());
        }
    }

    public void testReferencePropertyName() {
        final Databases databases = new Databases();
        final Database db1 = new Database(databases, "db1");
        db1.getOptions().put("javaPackage", "org.asyrinx.joey.sample");
        //
        final Table t_party = new Table(db1, "party", "p[eB");
        new Column(t_party, "party_id", "BIGINT", "0", true, true, "0");
        new Column(t_party, "name", "VARCHAR", "20", true, false, null);
        //
        final Table t_relation_type = new Table(db1, "relation_type", "֌W^");
        new Column(t_relation_type, "relation_type_id", "BIGINT", "0", true, true, "0");
        new Column(t_relation_type, "name", "VARCHAR", "20", true, false, null);
        //
        final Table t_relation_type_structure = new Table(db1, "relation_type_structure", "֌W^\");
        new Column(t_relation_type_structure, "relation_type_structure_id", "BIGINT", "0", true,
                true, "0");
        final Column colOriginRtId = new Column(t_relation_type_structure,
                "origin_relation_type_id", "BIGINT", "0", true, false, "0");
        final Column colDestRtId = new Column(t_relation_type_structure, "dest_relation_type_id",
                "BIGINT", "0", true, false, "0");
        colOriginRtId.setFk("relation_type.relation_type_id");
        colDestRtId.setFk("relation_type.relation_type_id");
        //
        final Table t_relation = new Table(db1, "relation", "֌W");
        new Column(t_relation, "relation_id", "BIGINT", "0", true, true, "0");
        final Column colOriginPartyId = new Column(t_relation, "origin_party_id", "BIGINT", "0",
                true, false, "0");
        final Column colDestPartyId = new Column(t_relation, "dest_party_id", "BIGINT", "0", true,
                false, "0");
        final Column colRelationType = new Column(t_relation, "relation_type_id", "BIGINT", "0",
                true, false, "0");
        colOriginPartyId.setFk("party.party_id");
        colDestPartyId.setFk("party.party_id");
        colRelationType.setFk("relation_type.relation_type_id");
        //
        final BasicBuilder builder = new BasicBuilder();
        final AppDomain domain = builder.execute(databases);
        //
        assertEquals(4, domain.getClasses().size());
        //
        final Entity c_party = domain.getClasses().getJavaType("Party");
        final Entity c_relation_type = domain.getClasses().getJavaType("RelationType");
        final Entity c_relation_type_struc = domain.getClasses().getJavaType(
                "RelationTypeStructure");
        final Entity c_relation = domain.getClasses().getJavaType("Relation");
        //
        final Property p_party_id = c_party.getProperties().getProperty("partyId");
        final Property p_relation_type_id = c_relation_type.getProperties().getProperty(
                "relationTypeId");
        //
        final Property p_origin_rt_id = c_relation_type_struc.getProperties().getProperty(
                "originRelationTypeId");
        final Property p_dest_rt_id = c_relation_type_struc.getProperties().getProperty(
                "destRelationTypeId");
        //
        final Reference ref_origin_to_rt = c_relation_type_struc.getReferences().getReference(0);
        assertEquals("RelationType", ref_origin_to_rt.getReferenceClassName());
        assertEquals(c_relation_type, ref_origin_to_rt.getReferenceClass());
        assertEquals(p_origin_rt_id, ref_origin_to_rt.getEntry(0).getLocal());
        assertEquals(p_relation_type_id, ref_origin_to_rt.getEntry(0).getForeign());
        assertEquals("relationTypeRelatedByOriginRelationTypeId", ref_origin_to_rt
                .getPropertyNameInLocal());
        assertEquals("relationTypeStructuresRelatedByOriginRelationTypeId", ref_origin_to_rt
                .getPropertyNameInReferred());
        assertEquals("relationTypeStructureRelatedByOriginRelationTypeId", ref_origin_to_rt
                .getPropertyNameInReferred(false));
        //
        final Reference ref_dest_to_rt = c_relation_type_struc.getReferences().getReference(1);
        assertEquals("RelationType", ref_dest_to_rt.getReferenceClassName());
        assertEquals(c_relation_type, ref_dest_to_rt.getReferenceClass());
        assertEquals(p_dest_rt_id, ref_dest_to_rt.getEntry(0).getLocal());
        assertEquals(p_relation_type_id, ref_dest_to_rt.getEntry(0).getForeign());
        assertEquals("relationTypeRelatedByDestRelationTypeId", ref_dest_to_rt
                .getPropertyNameInLocal());
        assertEquals("relationTypeStructuresRelatedByDestRelationTypeId", ref_dest_to_rt
                .getPropertyNameInReferred());
        assertEquals("relationTypeStructureRelatedByDestRelationTypeId", ref_dest_to_rt
                .getPropertyNameInReferred(false));
        //
        final Property p_role_id = c_relation.getProperties().getProperty(0);
        final Property p_origin_party_id = c_relation.getProperties().getProperty(1);
        final Property p_dest_party_id = c_relation.getProperties().getProperty(2);
        final Property p_relation_type_id2 = c_relation.getProperties().getProperty(3);
        //
        final Reference ref_origin_to_party = c_relation.getReferences().getReference(0);
        assertEquals("Party", ref_origin_to_party.getReferenceClassName());
        assertEquals(c_party, ref_origin_to_party.getReferenceClass());
        assertEquals(p_origin_party_id, ref_origin_to_party.getEntry(0).getLocal());
        assertEquals(p_party_id, ref_origin_to_party.getEntry(0).getForeign());
        assertEquals("partyRelatedByOriginPartyId", ref_origin_to_party.getPropertyNameInLocal());
        assertEquals("relationsRelatedByOriginPartyId", ref_origin_to_party
                .getPropertyNameInReferred());
        assertEquals("relationRelatedByOriginPartyId", ref_origin_to_party
                .getPropertyNameInReferred(false));
        //
        final Reference ref_dest_to_party = c_relation.getReferences().getReference(1);
        assertEquals("Party", ref_dest_to_party.getReferenceClassName());
        assertEquals(c_party, ref_dest_to_party.getReferenceClass());
        assertEquals(p_dest_party_id, ref_dest_to_party.getEntry(0).getLocal());
        assertEquals(p_party_id, ref_dest_to_party.getEntry(0).getForeign());
        assertEquals("partyRelatedByDestPartyId", ref_dest_to_party.getPropertyNameInLocal());
        assertEquals("relationsRelatedByDestPartyId", ref_dest_to_party.getPropertyNameInReferred());
        assertEquals("relationRelatedByDestPartyId", ref_dest_to_party
                .getPropertyNameInReferred(false));
        //
        final Reference ref_relation_type = c_relation.getReferences().getReference(2);
        assertEquals("RelationType", ref_relation_type.getReferenceClassName());
        assertEquals(c_relation_type, ref_relation_type.getReferenceClass());
        assertEquals(p_relation_type_id2, ref_relation_type.getEntry(0).getLocal());
        assertEquals(p_relation_type_id, ref_relation_type.getEntry(0).getForeign());
        assertEquals("relationType", ref_relation_type.getPropertyNameInLocal());
        assertEquals("relations", ref_relation_type.getPropertyNameInReferred());
        assertEquals("relation", ref_relation_type.getPropertyNameInReferred(false));
        //
        assertEquals(2, c_party.getReferreds().size());
        assertEquals(ref_origin_to_party, c_party.getReferreds().get(0));
        assertEquals(ref_dest_to_party, c_party.getReferreds().get(1));
        assertEquals(0, c_relation.getReferreds().size());
    }

    public void testExtendedClassesAndReference() {
        final Databases databases = new Databases();
        final Database db1 = new Database(databases, "db1");
        db1.getOptions().put("javaPackage", "org.asyrinx.joey.sample");
        //
        final Table t_component = new Table(db1, "component", "R|[lg");
        new Column(t_component, "component_id", "BIGINT", "0", true, true, "0");
        new Column(t_component, "name", "VARCHAR", "20", true, false, null);
        //
        final Table t_composite = new Table(db1, "composite", "R|Wbg");
        t_composite.setExtends("component");
        new Column(t_composite, "dummy", "VARCHAR", "20", true, false, null);
        //
        final Table t_structure = new Table(db1, "structure", "\");
        new Column(t_structure, "structure_id", "BIGINT", "0", true, true, "0");
        final Column compositeId = new Column(t_structure, "composite_id", "BIGINT", "0", true,
                false, "0");
        final Column componentId = new Column(t_structure, "component_id", "BIGINT", "0", true,
                false, "0");
        compositeId.setFk("composite.component_id");
        componentId.setFk("component.component_id");
        //
        final BasicBuilder builder = new BasicBuilder();
        final AppDomain domain = builder.execute(databases);
        //
        final Entity e_component = domain.getClasses().getJavaType("Component");
        final Entity e_composite = domain.getClasses().getJavaType("Composite");
        final Entity e_structure = domain.getClasses().getJavaType("Structure");
        //
        final Reference reference1 = e_structure.getReferences().getReference(0);
        assertEquals(e_composite, reference1.getReferenceClass());
        assertEquals("composite", reference1.getPropertyNameInLocal());
        //assertEquals("structuresRelatedByCompositeComponentId",
        // reference1.getPropertyNameInReferred());
        //assertEquals("structureRelatedByCompositeComponentId",
        // reference1.getPropertyNameInReferred(false));
        assertEquals("structures", reference1.getPropertyNameInReferred());
        assertEquals("structure", reference1.getPropertyNameInReferred(false));
        //
        final Reference reference2 = e_structure.getReferences().getReference(1);
        assertEquals(e_component, reference2.getReferenceClass());
        assertEquals("component", reference2.getPropertyNameInLocal());
        //assertEquals("structuresRelatedByComponentComponentId",
        // reference2.getPropertyNameInReferred());
        //assertEquals("structureRelatedByComponentComponentId",
        // reference2.getPropertyNameInReferred(false));
        assertEquals("structuresRelatedByComponentId", reference2.getPropertyNameInReferred());
        assertEquals("structureRelatedByComponentId", reference2.getPropertyNameInReferred(false));
    }

    public void testExtendedClassesAndReference2() {
        final Databases databases = new Databases();
        final Database db1 = new Database(databases, "db1");
        db1.getOptions().put("javaPackage", "org.asyrinx.joey.sample");
        //
        final Table t_party = new Table(db1, "party", "p[eB");
        new Column(t_party, "party_id", "BIGINT", "0", true, true, "0");
        new Column(t_party, "name", "VARCHAR", "20", true, false, null);
        //
        final Table t_action = new Table(db1, "action", "ANV");
        new Column(t_action, "action_id", "BIGINT", "0", true, true, "0");
        final Column c_partyId = new Column(t_action, "target_party_id", "BIGINT", "0", true,
                false, "0");
        c_partyId.setFk("party.party_id");
        new Column(t_action, "descriptions", "VARCHAR", "100", true, false, null);
        //
        final Table t_action_ex = new Table(db1, "action_ex", "ANVEx");
        t_action_ex.setExtends("action");
        final Column c_reporter_id = new Column(t_action_ex, "reporter_id", "BIGINT", "0", true,
                false, "0");
        c_reporter_id.setFk("party.party_id");
        //
        final BasicBuilder builder = new BasicBuilder();
        final AppDomain domain = builder.execute(databases);
        //
        final Entity e_party = domain.getClasses().getJavaType("Party");
        final Entity e_action = domain.getClasses().getJavaType("Action");
        final Entity e_action_ex = domain.getClasses().getJavaType("ActionEx");
        //
        final Reference reference1 = e_action.getReferences().getReference(0);
        assertEquals(e_party, reference1.getReferenceClass());
        assertEquals("party", reference1.getPropertyNameInLocal());
        assertEquals("actions", reference1.getPropertyNameInReferred());
        assertEquals("action", reference1.getPropertyNameInReferred(false));
        //
        final Reference reference2 = e_action_ex.getReferences().getReference(0);
        assertEquals(e_party, reference2.getReferenceClass());
        assertEquals("partyRelatedByReporterId", reference2.getPropertyNameInLocal());
        assertEquals("actionExs", reference2.getPropertyNameInReferred());
        assertEquals("actionEx", reference2.getPropertyNameInReferred(false));
    }

    public void testIndexAndUnique() {
        final Databases databases = new Databases();
        final Database db1 = new Database(databases, "db1");
        db1.getOptions().put("javaPackage", "org.asyrinx.joey.sample");
        //
        final Table t_party = new Table(db1, "party", "p[eB");
        new Column(t_party, "party_id", "BIGINT", "0", true, true, "0");
        final Column col_party_code = new Column(t_party, "party_code", "VARCHAR", "20", true,
                false, null);
        col_party_code.setUnique(true);
        final Column col_party_name = new Column(t_party, "name", "VARCHAR", "20", true, false,
                null);
        col_party_name.setIndexed(true);
        final Index index0 = new Index(t_party);
        new IndexEntry(index0, "party_code");
        new IndexEntry(index0, "name");
        //
        final BasicBuilder builder = new BasicBuilder();
        final AppDomain domain = builder.execute(databases);
        //
        assertEquals(1, t_party.getUniques().size());
        final Unique unique = (Unique) t_party.getUniques().getIndex(0);
        assertEquals(1, unique.size());
        assertEquals(col_party_code, unique.getEntry(0).getColumn());
        //
        assertEquals(2, t_party.getIndexes().size());
        assertEquals(index0, t_party.getIndexes().getIndex(0));
        final Index index1 = t_party.getIndexes().getIndex(1);
        assertEquals(1, index1.size());
        assertEquals(col_party_name, index1.getEntry(0).getColumn());
        //
        assertEquals(1, domain.getClasses().size());
        final Entity ety_party = domain.getClasses().getJavaType(0);
        assertEquals(4, ety_party.getKeys().size());
        final EntityKey key0 = ety_party.getKeys().getKey(0);
        final EntityKey key1 = ety_party.getKeys().getKey(1);
        final EntityKey key2 = ety_party.getKeys().getKey(2);
        final EntityKey key3 = ety_party.getKeys().getKey(3);
        //
        assertEquals(ety_party, key0.getParent());
        assertEquals(ety_party, key1.getParent());
        assertEquals(ety_party, key2.getParent());
        assertEquals(ety_party, key3.getParent());
        //
        assertEquals(EntityKeyType.PK, key0.getKeyType());
        assertEquals(1, key0.size());
        assertEquals("partyId", key0.getEntry(0).getName());
        assertEquals("primaryKey", key0.getName());
        //
        assertEquals(EntityKeyType.INDEX, key1.getKeyType());
        assertEquals(2, key1.size());
        assertEquals("partyCode", key1.getEntry(0).getName());
        assertEquals("name", key1.getEntry(1).getName());
        assertEquals("keyPartyCodeName", key1.getName());
        //
        assertEquals(EntityKeyType.INDEX, key2.getKeyType());
        assertEquals(1, key2.size());
        assertEquals("name", key2.getEntry(0).getName());
        assertEquals("keyName", key2.getName());
        //
        assertEquals(EntityKeyType.UNIQUE, key3.getKeyType());
        assertEquals(1, key3.size());
        assertEquals("partyCode", key3.getEntry(0).getName());
        assertEquals("keyPartyCode", key3.getName());
    }

    public void testBooleanEnum() {
        final Databases databases = new Databases();
        final Database db1 = new Database(databases, "db1");
        db1.getOptions().put("javaPackage", "org.asyrinx.joey.sample");
        //
        final Table t_party = new Table(db1, "party", "p[eB");
        new Column(t_party, "party_id", "BIGINT", "0", true, true, "0");
        new Column(t_party, "name", "VARCHAR", "20", true, false, null);
        final Column col_deleted = new Column(t_party, "deleted", "INTEGER", "20", true, false,
                null);
        col_deleted.setEnum("BooleanEnum");
        //
        final BasicBuilder builder = new BasicBuilder();
        final Map props = new HashMap();
        props.put("joey-gen.proj.base.package", "org.asyrinx.joey.sample");
        builder.setProperties(props);
        final AppDomain domain = builder.execute(databases);
        //
        assertEquals(1, domain.getClasses().size());
        final Entity ety_party = domain.getClasses().getJavaType(0);
        assertEquals(3, ety_party.getProperties().size());
        final Property prop_deleted = ety_party.getProperties().getProperty(2);
        assertEquals("deleted", prop_deleted.getName());
        assertEquals(JoeyRuntimeClass.JAVA_BOOLEAN_ENUM, prop_deleted.getEnumType());
    }

}