/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/08/10 17:36:30
 */
package test.org.asyrinx.joey.gen.model.rdb;

import java.util.Iterator;

import junit.framework.TestCase;

import org.asyrinx.joey.gen.model.rdb.Column;
import org.asyrinx.joey.gen.model.rdb.ColumnSet;

/**
 * @author akima
 */
public class ColumnSetTest extends TestCase {

    public static void main(String[] args) {
        junit.swingui.TestRunner.run(ColumnSetTest.class);
    }

    /**
     * Constructor for ColumnSetTest.
     * 
     * @param name
     */
    public ColumnSetTest(String name) {
        super(name);
    }

    private ColumnSet columnSet = null;

    private Column col1;

    private Column col2;

    /**
     * @see TestCase#setUp()
     */
    protected void setUp() throws Exception {
        this.columnSet = new ColumnSet(null);
        col1 = new Column();
        col1.setName("sample_id");
        col1.setLabel("ID");
        col1.setType("long");
        col1.setPrimaryKey(true);
        columnSet.add(col1);
        col2 = new Column();
        col2.setName("name");
        col2.setLabel("O");
        col2.setType("VARCHAR");
        col2.setSize("30");
        columnSet.add(col2);
    }

    public void testAdd() {
        try {
            columnSet.add(null);
            fail();
        } catch (NullPointerException e) {
            //NullPointerException throwȂƂ
        }
        //
        final Column col = new Column();
        col.setName("update_date");
        col.setLabel("XV");
        col.setType("DATE");
        columnSet.add(col);
        assertEquals(3, columnSet.size());
        assertEquals(2, columnSet.indexOf("update_date"));
        assertEquals(col, columnSet.getColumn("update_date"));
    }

    public void testClear() {
        columnSet.clear();
        assertEquals(true, columnSet.isEmpty());
        assertEquals(0, columnSet.size());
    }

    /*
     * Class under test for boolean contains(String)
     */
    public void testContainsString() {
        assertEquals(true, columnSet.contains("sample_id"));
        assertEquals(true, columnSet.contains("name"));
        assertEquals(false, columnSet.contains("non_exist_col"));
        assertEquals(false, columnSet.contains((String) null));
    }

    /*
     * Class under test for boolean contains(Column)
     */
    public void testContainsColumn() {
        assertEquals(true, columnSet.contains(col1));
        assertEquals(true, columnSet.contains(col2));
        assertEquals(false, columnSet.contains(new Column()));
        assertEquals(false, columnSet.contains((Column) null));
    }

    public void testGet() {
        assertEquals(col1, columnSet.getColumn("sample_id"));
        assertEquals(col2, columnSet.getColumn("name"));
        assertEquals(null, columnSet.getColumn("non_exist_col"));
    }

    public void testIndexOf() {
        assertEquals(0, columnSet.indexOf("sample_id"));
        assertEquals(1, columnSet.indexOf("name"));
    }

    public void testIsEmpty() {
        assertEquals(false, columnSet.isEmpty());
        columnSet.clear();
        assertEquals(true, columnSet.isEmpty());
        assertEquals(true, new ColumnSet(null).isEmpty());
    }

    public void testIterator() {
        final Iterator iterator = columnSet.iterator();
        assertEquals(true, iterator.hasNext());
        assertEquals(col1, iterator.next());
        assertEquals(true, iterator.hasNext());
        assertEquals(col2, iterator.next());
        assertEquals(false, iterator.hasNext());
    }

    public void testRemove() {
        columnSet.removeColumn("non_exist_col");
        assertEquals(2, columnSet.size());
        assertEquals(col1, columnSet.getColumn("sample_id"));
        assertEquals(col2, columnSet.getColumn("name"));
        //
        columnSet.removeColumn("name");
        assertEquals(1, columnSet.size());
        assertEquals(col1, columnSet.getColumn("sample_id"));
        assertEquals(null, columnSet.getColumn("name"));
    }

    public void testSize() {
        assertEquals(2, columnSet.size());
    }

}