/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/11/08 10:30:01
 */
package test.org.asyrinx.joey.gen.model.rdb;

import org.asyrinx.joey.gen.command.rdb2java.standard.BasicBuilder;
import org.asyrinx.joey.gen.model.java.AppDomain;
import org.asyrinx.joey.gen.model.rdb.Column;
import org.asyrinx.joey.gen.model.rdb.Database;
import org.asyrinx.joey.gen.model.rdb.Databases;
import org.asyrinx.joey.gen.model.rdb.Table;

import junit.framework.TestCase;

/**
 * @author takeshi
 */
public class DatabaseTest extends TestCase {

    public static void main(String[] args) {
        junit.swingui.TestRunner.run(DatabaseTest.class);
    }

    public void testGetColumn(){
        final Databases databases = new Databases();
        final Database db1 = new Database(databases, "db1");
        db1.getOptions().put("javaPackage", "org.asyrinx.joey.sample");
        //
        final Table t_party = new Table(db1, "party", "p[eB");
        final Column col_party_id = new Column(t_party, "party_id", "BIGINT", "0", true, true, "0");
        final Column col_party_name = new Column(t_party, "name", "VARCHAR", "20", true, false, null);
        //
        final Table t_role = new Table(db1, "role", "[");
        final Column col_role_id = new Column(t_role, "role_id", "BIGINT", "0", true, true, "0");
        final Column col_role_party_id = new Column(t_role, "party_id", "BIGINT", "0", true, false, "0");
        //
        final BasicBuilder builder = new BasicBuilder();
        //final AppDomain domain = builder.execute(databases);
        //
        assertEquals(col_party_id, db1.getColumn("party.party_id"));
        assertEquals(col_party_name, db1.getColumn("party.name"));
        //
        assertEquals(col_role_id, db1.getColumn("role.role_id"));
        assertEquals(col_role_party_id, db1.getColumn("role.party_id"));
    }
    
}
