/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/08/16 15:56:28
 */
package test.org.asyrinx.joey.gen.model.rdb;

import org.asyrinx.joey.gen.command.rdb.MergeDatabases;
import org.asyrinx.joey.gen.model.rdb.Database;
import org.asyrinx.joey.gen.model.rdb.Databases;
import org.asyrinx.joey.gen.model.rdb.Table;

import junit.framework.TestCase;

/**
 * @author akima
 */
public class DatabasesTest extends TestCase {

    public static void main(String[] args) {
        junit.swingui.TestRunner.run(DatabasesTest.class);
    }

    public void testMergeDuplicates() {
        final Databases databases = new Databases();
        final Database db1 = new Database(databases, "db1");
        final Database db1_1 = new Database(databases, "db1");
        final Database db2 = new Database(databases, "db2");
        //
        db1.getTables().add(new Table("t1_1"));
        db1.getTables().add(new Table("t1_2"));
        db1_1.getTables().add(new Table("t1_3"));
        db1_1.getTables().add(new Table("t1_4"));
        db2.getTables().add(new Table("t2_1"));
        db2.getTables().add(new Table("t2_2"));
        //
        new MergeDatabases().execute(databases);
        //
        assertEquals(2, databases.getDatabases().size());
        assertEquals(db1, databases.getDatabases().getDatabase(0));
        assertEquals(db2, databases.getDatabases().getDatabase(1));
        //
        assertEquals(4, db1.getTables().size());
        assertEquals("t1_1", db1.getTables().getTable(0).getName());
        assertEquals("t1_2", db1.getTables().getTable(1).getName());
        assertEquals("t1_3", db1.getTables().getTable(2).getName());
        assertEquals("t1_4", db1.getTables().getTable(3).getName());
        assertEquals("t2_1", db2.getTables().getTable(0).getName());
        assertEquals("t2_2", db2.getTables().getTable(1).getName());
    }
}